/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.hadoop;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.extractor.extract.AbstractSource;
import org.apache.gobblin.source.extractor.hadoop.OldApiHadoopFileInputExtractor;
import org.apache.gobblin.source.workunit.Extract;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;

public abstract class OldApiHadoopFileInputSource<S, D, K, V>
extends AbstractSource<S, D> {
    public List<WorkUnit> getWorkunits(SourceState state) {
        JobConf jobConf = new JobConf(new Configuration());
        for (String key : state.getPropertyNames()) {
            jobConf.set(key, state.getProp(key));
        }
        if (state.contains("source.hadoop.file.input.paths")) {
            for (String inputPath : state.getPropAsList("source.hadoop.file.input.paths")) {
                FileInputFormat.addInputPath((JobConf)jobConf, (Path)new Path(inputPath));
            }
        }
        try {
            FileInputFormat<K, V> fileInputFormat = this.getFileInputFormat((State)state, jobConf);
            InputSplit[] fileSplits = fileInputFormat.getSplits(jobConf, state.getPropAsInt("source.hadoop.file.splits.desired", 1));
            if (fileSplits == null || fileSplits.length == 0) {
                return ImmutableList.of();
            }
            Extract.TableType tableType = state.contains("extract.table.type") ? Extract.TableType.valueOf((String)state.getProp("extract.table.type").toUpperCase()) : null;
            String tableNamespace = state.getProp("extract.namespace");
            String tableName = state.getProp("extract.table.name");
            ArrayList workUnits = Lists.newArrayListWithCapacity((int)fileSplits.length);
            for (InputSplit inputSplit : fileSplits) {
                FileSplit fileSplit = (FileSplit)inputSplit;
                Extract extract = this.createExtract(tableType, tableNamespace, tableName);
                WorkUnit workUnit = WorkUnit.create((Extract)extract);
                workUnit.setProp("source.hadoop.file.split.bytes.string", (Object)HadoopUtils.serializeToString((Writable)fileSplit));
                workUnit.setProp("source.hadoop.file.split.path", (Object)fileSplit.getPath().toString());
                workUnits.add(workUnit);
            }
            return workUnits;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to get workunits", ioe);
        }
    }

    public Extractor<S, D> getExtractor(WorkUnitState workUnitState) throws IOException {
        if (!workUnitState.contains("source.hadoop.file.split.bytes.string")) {
            throw new IOException("No serialized FileSplit found in WorkUnitState " + workUnitState.getId());
        }
        JobConf jobConf = new JobConf(new Configuration());
        for (String key : workUnitState.getPropertyNames()) {
            jobConf.set(key, workUnitState.getProp(key));
        }
        String fileSplitBytesStr = workUnitState.getProp("source.hadoop.file.split.bytes.string");
        FileSplit fileSplit = (FileSplit)HadoopUtils.deserializeFromString(FileSplit.class, (String)fileSplitBytesStr);
        FileInputFormat<K, V> fileInputFormat = this.getFileInputFormat((State)workUnitState, jobConf);
        RecordReader recordReader = fileInputFormat.getRecordReader((InputSplit)fileSplit, jobConf, Reporter.NULL);
        boolean readKeys = workUnitState.getPropAsBoolean("source.hadoop.file.read.keys", false);
        return this.getExtractor(workUnitState, recordReader, fileSplit, readKeys);
    }

    public void shutdown(SourceState state) {
    }

    protected FileInputFormat<K, V> getFileInputFormat(State state, JobConf jobConf) {
        Preconditions.checkArgument((boolean)state.contains("source.hadoop.file.input.format.class"));
        try {
            return (FileInputFormat)ReflectionUtils.newInstance(Class.forName(state.getProp("source.hadoop.file.input.format.class")), (Configuration)new Configuration());
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }

    protected abstract OldApiHadoopFileInputExtractor<S, D, K, V> getExtractor(WorkUnitState var1, RecordReader<K, V> var2, FileSplit var3, boolean var4);
}

