/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.util.ForkOperatorUtils;
import org.apache.gobblin.util.WriterUtils;
import org.apache.gobblin.writer.FsDataWriter;
import org.apache.gobblin.writer.FsDataWriterBuilder;
import org.apache.hadoop.fs.FileSystem;

public class AvroHdfsDataWriter
extends FsDataWriter<GenericRecord> {
    private final Schema schema;
    private final OutputStream stagingFileOutputStream;
    private final DatumWriter<GenericRecord> datumWriter;
    private final DataFileWriter<GenericRecord> writer;
    private final boolean skipNullRecord;
    protected final AtomicLong count = new AtomicLong(0L);

    public AvroHdfsDataWriter(FsDataWriterBuilder<Schema, GenericRecord> builder, State state) throws IOException {
        super(builder, state);
        CodecFactory codecFactory = WriterUtils.getCodecFactory((Optional)Optional.fromNullable((Object)this.properties.getProp(ForkOperatorUtils.getPropertyNameForBranch((String)"writer.codec.type", (int)this.numBranches, (int)this.branchId))), (Optional)Optional.fromNullable((Object)this.properties.getProp(ForkOperatorUtils.getPropertyNameForBranch((String)"writer.deflate.level", (int)this.numBranches, (int)this.branchId))));
        this.schema = (Schema)builder.getSchema();
        this.stagingFileOutputStream = this.createStagingFileOutputStream();
        this.datumWriter = new GenericDatumWriter();
        this.writer = (DataFileWriter)this.closer.register(this.createDataFileWriter(codecFactory));
        this.skipNullRecord = state.getPropAsBoolean("writer.skipNullRecord", false);
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public void write(GenericRecord record) throws IOException {
        if (this.skipNullRecord && record == null) {
            return;
        }
        Preconditions.checkNotNull((Object)record);
        this.writer.append((Object)record);
        this.count.incrementAndGet();
    }

    public long recordsWritten() {
        return this.count.get();
    }

    private DataFileWriter<GenericRecord> createDataFileWriter(CodecFactory codecFactory) throws IOException {
        DataFileWriter writer = new DataFileWriter(this.datumWriter);
        writer.setCodec(codecFactory);
        return writer.create(this.schema, this.stagingFileOutputStream);
    }

    @Override
    public boolean isSpeculativeAttemptSafe() {
        return this.writerAttemptIdOptional.isPresent() && this.getClass() == AvroHdfsDataWriter.class;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }
}

