/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import java.io.IOException;
import java.util.Set;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metadata.GlobalMetadataCollector;
import org.apache.gobblin.metadata.types.GlobalMetadata;
import org.apache.gobblin.type.RecordWithMetadata;
import org.apache.gobblin.util.ForkOperatorUtils;
import org.apache.gobblin.writer.DataWriter;
import org.apache.gobblin.writer.MetadataAwareWriter;

public class MetadataWriterWrapper<D>
implements DataWriter<Object> {
    private final DataWriter wrappedWriter;
    private final Class<? extends D> writerDataClass;
    private final int numBranches;
    private final int branchId;
    private final State properties;
    private final GlobalMetadataCollector metadataCollector;

    public MetadataWriterWrapper(DataWriter<D> wrappedWriter, Class<? extends D> writerDataClass, int numBranches, int branchId, State writerProperties) {
        this.wrappedWriter = wrappedWriter;
        this.writerDataClass = writerDataClass;
        this.numBranches = numBranches;
        this.branchId = branchId;
        this.properties = writerProperties;
        GlobalMetadata defaultMetadata = null;
        if (wrappedWriter instanceof MetadataAwareWriter) {
            defaultMetadata = ((MetadataAwareWriter)wrappedWriter).getDefaultMetadata();
        }
        this.metadataCollector = new GlobalMetadataCollector(defaultMetadata, -1);
    }

    public void write(Object untypedRecord) throws IOException {
        if (untypedRecord instanceof RecordWithMetadata) {
            RecordWithMetadata record = (RecordWithMetadata)untypedRecord;
            GlobalMetadata globalMetadata = record.getMetadata().getGlobalMetadata();
            this.metadataCollector.processMetadata(globalMetadata);
            if (RecordWithMetadata.class.isAssignableFrom(this.writerDataClass)) {
                this.wrappedWriter.write((Object)record);
            } else {
                this.wrappedWriter.write(record.getRecord());
            }
        } else {
            this.metadataCollector.processMetadata(null);
            this.wrappedWriter.write(untypedRecord);
        }
    }

    protected void writeMetadata() throws IOException {
        String metadataStr;
        Set collectedMetadata = this.metadataCollector.getMetadataRecords();
        if (collectedMetadata.isEmpty()) {
            return;
        }
        String propName = ForkOperatorUtils.getPropertyNameForBranch((String)"writer._internal.metadata", (int)this.numBranches, (int)this.branchId);
        if (collectedMetadata.size() == 1) {
            metadataStr = ((GlobalMetadata)collectedMetadata.iterator().next()).toJson();
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            boolean first = true;
            for (GlobalMetadata md : collectedMetadata) {
                if (!first) {
                    sb.append(',');
                }
                sb.append(md.toJson());
                first = false;
            }
            sb.append(']');
            metadataStr = sb.toString();
        }
        this.properties.setProp(propName, (Object)metadataStr);
    }

    public void commit() throws IOException {
        this.writeMetadata();
        this.wrappedWriter.commit();
    }

    public void cleanup() throws IOException {
        this.wrappedWriter.cleanup();
    }

    public long recordsWritten() {
        return this.wrappedWriter.recordsWritten();
    }

    public long bytesWritten() throws IOException {
        return this.wrappedWriter.recordsWritten();
    }

    public void close() throws IOException {
        this.wrappedWriter.close();
    }

    public void flush() throws IOException {
        this.wrappedWriter.flush();
    }
}

