/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.partitioner;

import com.google.common.base.Optional;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.util.AvroUtils;
import org.apache.gobblin.util.ForkOperatorUtils;
import org.apache.gobblin.writer.partitioner.TimeBasedWriterPartitioner;

public class TimeBasedAvroWriterPartitioner
extends TimeBasedWriterPartitioner<GenericRecord> {
    public static final String WRITER_PARTITION_COLUMNS = "writer.partition.columns";
    private final Optional<List<String>> partitionColumns;

    public TimeBasedAvroWriterPartitioner(State state) {
        this(state, 1, 0);
    }

    public TimeBasedAvroWriterPartitioner(State state, int numBranches, int branchId) {
        super(state, numBranches, branchId);
        this.partitionColumns = TimeBasedAvroWriterPartitioner.getWriterPartitionColumns(state, numBranches, branchId);
    }

    private static Optional<List<String>> getWriterPartitionColumns(State state, int numBranches, int branchId) {
        String propName = ForkOperatorUtils.getPropertyNameForBranch((String)WRITER_PARTITION_COLUMNS, (int)numBranches, (int)branchId);
        return state.contains(propName) ? Optional.of((Object)state.getPropAsList(propName)) : Optional.absent();
    }

    @Override
    public long getRecordTimestamp(GenericRecord record) {
        return TimeBasedAvroWriterPartitioner.getRecordTimestamp(this.getWriterPartitionColumnValue(record));
    }

    private static long getRecordTimestamp(Optional<Object> writerPartitionColumnValue) {
        return writerPartitionColumnValue.orNull() instanceof Long ? (Long)writerPartitionColumnValue.get() : System.currentTimeMillis();
    }

    private Optional<Object> getWriterPartitionColumnValue(GenericRecord record) {
        if (!this.partitionColumns.isPresent()) {
            return Optional.absent();
        }
        for (String partitionColumn : (List)this.partitionColumns.get()) {
            Optional fieldValue = AvroUtils.getFieldValue((GenericRecord)record, (String)partitionColumn);
            if (!fieldValue.isPresent()) continue;
            return fieldValue;
        }
        return Optional.absent();
    }
}

