/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.eventhub.writer;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.microsoft.azure.servicebus.SharedAccessSignatureTokenProvider;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.eventhub.writer.EventhubRequest;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.password.PasswordManager;
import org.apache.gobblin.writer.Batch;
import org.apache.gobblin.writer.BatchAsyncDataWriter;
import org.apache.gobblin.writer.SyncDataWriter;
import org.apache.gobblin.writer.WriteCallback;
import org.apache.gobblin.writer.WriteResponse;
import org.apache.gobblin.writer.WriteResponseFuture;
import org.apache.gobblin.writer.WriteResponseMapper;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventhubDataWriter
implements SyncDataWriter<String>,
BatchAsyncDataWriter<String> {
    private static final Logger log = LoggerFactory.getLogger(EventhubDataWriter.class);
    private static final Logger LOG = LoggerFactory.getLogger(EventhubDataWriter.class);
    private HttpClient httpclient;
    private final String namespaceName;
    private final String eventHubName;
    private final String sasKeyName;
    private final String sasKey;
    private final String targetURI;
    private final Meter bytesWritten;
    private final Meter recordsAttempted;
    private final Meter recordsSuccess;
    private final Meter recordsFailed;
    private final Timer writeTimer;
    private long postStartTimestamp = 0L;
    private long sigExpireInMinute = 1L;
    private String signature = "";
    private MetricContext metricContext;
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final WriteResponseMapper<Integer> WRITE_RESPONSE_WRAPPER = new WriteResponseMapper<Integer>(){

        public WriteResponse wrap(final Integer returnCode) {
            return new WriteResponse<Integer>(){

                public Integer getRawResponse() {
                    return returnCode;
                }

                public String getStringResponse() {
                    return returnCode.toString();
                }

                public long bytesWritten() {
                    return -1L;
                }
            };
        }
    };

    public EventhubDataWriter(Properties properties) {
        PasswordManager manager = PasswordManager.getInstance((Properties)properties);
        this.namespaceName = properties.getProperty("eventhub.namespace");
        this.eventHubName = properties.getProperty("eventhub.hubname");
        this.sasKeyName = properties.getProperty("eventhub.sas.keyname");
        String encodedSasKey = properties.getProperty("eventhub.sas.keyvalue");
        this.sasKey = manager.readPassword(encodedSasKey);
        this.targetURI = "https://" + this.namespaceName + ".servicebus.windows.net/" + this.eventHubName + "/messages";
        this.httpclient = HttpClients.createDefault();
        this.metricContext = Instrumented.getMetricContext((State)new State(properties), EventhubDataWriter.class);
        this.recordsAttempted = this.metricContext.meter("eventhub.writer.records.attempted");
        this.recordsSuccess = this.metricContext.meter("eventhub.writer.records.success");
        this.recordsFailed = this.metricContext.meter("eventhub.writer.records.failed");
        this.bytesWritten = this.metricContext.meter("eventhub.writer.bytes.written");
        this.writeTimer = this.metricContext.timer("eventhub.writer.write.time");
    }

    public EventhubDataWriter(Properties properties, HttpClient httpclient) {
        this(properties);
        this.httpclient = httpclient;
    }

    public Future<WriteResponse> write(Batch<String> batch, WriteCallback callback) {
        Timer.Context context = this.writeTimer.time();
        int returnCode = 0;
        LOG.info("Dispatching batch " + batch.getId());
        this.recordsAttempted.mark((long)batch.getRecords().size());
        try {
            String encoded = this.encodeBatch(batch);
            returnCode = this.request(encoded);
            WriteResponse response = WRITE_RESPONSE_WRAPPER.wrap((Object)returnCode);
            callback.onSuccess((Object)response);
            this.bytesWritten.mark((long)encoded.length());
            this.recordsSuccess.mark((long)batch.getRecords().size());
        }
        catch (Exception e) {
            LOG.error("Dispatching batch " + batch.getId() + " failed :" + e.toString());
            callback.onFailure((Throwable)e);
            this.recordsFailed.mark((long)batch.getRecords().size());
        }
        context.close();
        ListenableFuture future = Futures.immediateFuture((Object)returnCode);
        return new WriteResponseFuture((Future)future, WRITE_RESPONSE_WRAPPER);
    }

    public WriteResponse write(String record) throws IOException {
        this.recordsAttempted.mark();
        String encoded = this.encodeRecord(record);
        int returnCode = this.request(encoded);
        this.recordsSuccess.mark();
        this.bytesWritten.mark((long)encoded.length());
        return WRITE_RESPONSE_WRAPPER.wrap((Object)returnCode);
    }

    public void refreshSignature() {
        if (this.postStartTimestamp == 0L || System.nanoTime() - this.postStartTimestamp > Duration.ofMinutes(this.sigExpireInMinute).toNanos()) {
            try {
                this.signature = SharedAccessSignatureTokenProvider.generateSharedAccessSignature((String)this.sasKeyName, (String)this.sasKey, (String)this.namespaceName, (Duration)Duration.ofMinutes(this.sigExpireInMinute));
                this.postStartTimestamp = System.nanoTime();
                LOG.info("Signature is refreshing: " + this.signature);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private int request(String encoded) throws IOException {
        this.refreshSignature();
        HttpPost httpPost = new HttpPost(this.targetURI);
        httpPost.setHeader("Content-type", "application/vnd.microsoft.servicebus.json");
        httpPost.setHeader("Authorization", this.signature);
        httpPost.setHeader("Host", this.namespaceName + ".servicebus.windows.net ");
        StringEntity entity = new StringEntity(encoded);
        httpPost.setEntity((HttpEntity)entity);
        HttpResponse response = this.httpclient.execute((HttpUriRequest)httpPost);
        StatusLine status = response.getStatusLine();
        HttpEntity entity2 = response.getEntity();
        EntityUtils.consume((HttpEntity)entity2);
        int returnCode = status.getStatusCode();
        if (returnCode != 201) {
            LOG.error(new IOException(status.getReasonPhrase()).toString());
            throw new IOException(status.getReasonPhrase());
        }
        return returnCode;
    }

    private String encodeBatch(Batch<String> batch) throws IOException {
        List records = batch.getRecords();
        ArrayList<EventhubRequest> arrayList = new ArrayList<EventhubRequest>();
        for (String record : records) {
            arrayList.add(new EventhubRequest(record));
        }
        return mapper.writeValueAsString(arrayList);
    }

    private String encodeRecord(String record) throws IOException {
        ArrayList<EventhubRequest> arrayList = new ArrayList<EventhubRequest>();
        arrayList.add(new EventhubRequest(record));
        return mapper.writeValueAsString(arrayList);
    }

    public void close() throws IOException {
        if (this.httpclient instanceof CloseableHttpClient) {
            ((CloseableHttpClient)this.httpclient).close();
        }
    }

    public void cleanup() {
    }

    public void flush() {
    }
}

