/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AbortedException;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.RequestClientOptions;
import com.amazonaws.ResetException;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.SDKGlobalTime;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.Signer;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressInputStream;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.SDKProgressPublisher;
import com.amazonaws.handlers.CredentialsRequestHandler;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.http.UnreliableTestConfig;
import com.amazonaws.http.apache.client.impl.ApacheHttpClientFactory;
import com.amazonaws.http.apache.client.impl.ConnectionManagerAwareHttpClient;
import com.amazonaws.http.apache.request.impl.ApacheHttpRequestFactory;
import com.amazonaws.http.apache.utils.ApacheUtils;
import com.amazonaws.http.client.HttpClientFactory;
import com.amazonaws.http.exception.HttpRequestTimeoutException;
import com.amazonaws.http.request.HttpRequestFactory;
import com.amazonaws.http.settings.HttpClientSettings;
import com.amazonaws.http.timers.client.ClientExecutionTimeoutException;
import com.amazonaws.http.timers.client.ClientExecutionTimer;
import com.amazonaws.http.timers.client.SdkInterruptedException;
import com.amazonaws.http.timers.request.HttpRequestAbortTaskTracker;
import com.amazonaws.http.timers.request.HttpRequestTimer;
import com.amazonaws.internal.CRC32MismatchException;
import com.amazonaws.internal.ReleasableInputStream;
import com.amazonaws.internal.ResettableInputStream;
import com.amazonaws.internal.SdkBufferedInputStream;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.retry.internal.AuthErrorRetryStrategy;
import com.amazonaws.retry.internal.AuthRetryParameters;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CapacityManager;
import com.amazonaws.util.CollectionUtils;
import com.amazonaws.util.CountingInputStream;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.ImmutableMapParameter;
import com.amazonaws.util.ResponseMetadataCache;
import com.amazonaws.util.TimingInfo;
import com.amazonaws.util.UnreliableFilterInputStream;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.StatusLine;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.pool.ConnPoolControl;
import org.apache.http.protocol.HttpContext;

@ThreadSafe
public class AmazonHttpClient {
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String HEADER_SDK_TRANSACTION_ID = "amz-sdk-invocation-id";
    public static final String HEADER_SDK_RETRY_INFO = "amz-sdk-retry";
    static final Log log;
    private static final Log requestIdLog;
    private static final Log requestLog;
    private static final HttpClientFactory<ConnectionManagerAwareHttpClient> httpClientFactory;
    private static UnreliableTestConfig unreliableTestConfig;
    private static final int THROTTLED_RETRY_COST = 5;
    private static final int THROTTLED_RETRIES = 100;
    private final HttpRequestFactory<HttpRequestBase> httpRequestFactory = new ApacheHttpRequestFactory();
    private ConnectionManagerAwareHttpClient httpClient;
    private final ClientConfiguration config;
    private final HttpClientSettings httpClientSettings;
    private final ResponseMetadataCache responseMetadataCache;
    private final HttpRequestTimer httpRequestTimer;
    private final CapacityManager retryCapacity;
    private final ClientExecutionTimer clientExecutionTimer;
    private final RequestMetricCollector requestMetricCollector;
    private volatile int timeOffset = SDKGlobalTime.getGlobalTimeOffset();

    public AmazonHttpClient(ClientConfiguration config) {
        this(config, null);
    }

    public AmazonHttpClient(ClientConfiguration config, RequestMetricCollector requestMetricCollector) {
        this(config, requestMetricCollector, false);
    }

    public AmazonHttpClient(ClientConfiguration config, RequestMetricCollector requestMetricCollector, boolean useBrowserCompatibleHostNameVerifier) {
        this(config, requestMetricCollector, HttpClientSettings.adapt(config, useBrowserCompatibleHostNameVerifier));
        this.httpClient = httpClientFactory.create(this.httpClientSettings);
    }

    @SdkTestInternalApi
    public AmazonHttpClient(ClientConfiguration clientConfig, ConnectionManagerAwareHttpClient httpClient, RequestMetricCollector requestMetricCollector) {
        this(clientConfig, requestMetricCollector, HttpClientSettings.adapt(clientConfig, false));
        this.httpClient = httpClient;
    }

    private AmazonHttpClient(ClientConfiguration clientConfig, RequestMetricCollector requestMetricCollector, HttpClientSettings httpClientSettings) {
        this.config = clientConfig;
        this.httpClientSettings = httpClientSettings;
        this.requestMetricCollector = requestMetricCollector;
        this.responseMetadataCache = new ResponseMetadataCache(clientConfig.getResponseMetadataCacheSize());
        this.httpRequestTimer = new HttpRequestTimer();
        this.clientExecutionTimer = new ClientExecutionTimer();
        int throttledRetryMaxCapacity = clientConfig.useThrottledRetries() ? 500 : -1;
        this.retryCapacity = new CapacityManager(throttledRetryMaxCapacity);
    }

    private static String createUserAgentString(String existingUserAgentString, String userAgent) {
        if (existingUserAgentString.contains(userAgent)) {
            return existingUserAgentString;
        }
        return existingUserAgentString.trim() + " " + userAgent.trim();
    }

    private static boolean isTemporaryRedirect(org.apache.http.HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        return status == 307 && response.getHeaders("Location") != null && response.getHeaders("Location").length > 0;
    }

    static void configUnreliableTestConditions(UnreliableTestConfig config) {
        unreliableTestConfig = config;
    }

    @SdkTestInternalApi
    public HttpRequestTimer getHttpRequestTimer() {
        return this.httpRequestTimer;
    }

    @SdkTestInternalApi
    public ClientExecutionTimer getClientExecutionTimer() {
        return this.clientExecutionTimer;
    }

    public ResponseMetadata getResponseMetadataForRequest(AmazonWebServiceRequest request) {
        return this.responseMetadataCache.get(request);
    }

    public <T> Response<T> execute(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpResponseHandler<AmazonServiceException> errorResponseHandler, ExecutionContext executionContext) {
        if (executionContext == null) {
            throw new AmazonClientException("Internal SDK Error: No execution context parameter specified.");
        }
        try {
            return this.executeWithTimer(request, this.getNonNullResponseHandler(responseHandler), this.getNonNullResponseHandler(errorResponseHandler), executionContext);
        }
        catch (InterruptedException ie) {
            throw this.handleInterruptedException(executionContext, ie);
        }
        catch (AbortedException ae) {
            throw this.handleAbortedException(executionContext, ae);
        }
    }

    private <T> HttpResponseHandler<T> getNonNullResponseHandler(HttpResponseHandler<T> responseHandler) {
        if (responseHandler != null) {
            return responseHandler;
        }
        return new HttpResponseHandler<T>(){

            @Override
            public T handle(HttpResponse response) throws Exception {
                return null;
            }

            @Override
            public boolean needsConnectionLeftOpen() {
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Response<T> executeWithTimer(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpResponseHandler<AmazonServiceException> errorResponseHandler, ExecutionContext executionContext) throws InterruptedException {
        try {
            executionContext.setClientExecutionTrackerTask(this.clientExecutionTimer.startTimer(this.getClientExecutionTimeout(request.getOriginalRequest())));
            Response<T> response = this.doExecute(request, responseHandler, errorResponseHandler, executionContext);
            return response;
        }
        finally {
            executionContext.getClientExecutionTrackerTask().cancelTask();
        }
    }

    private <T> Response<T> doExecute(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpResponseHandler<AmazonServiceException> errorResponseHandler, ExecutionContext executionContext) throws InterruptedException {
        Map<String, List<String>> customQueryParams;
        List<RequestHandler2> requestHandler2s = this.requestHandler2s(request, executionContext);
        AmazonWebServiceRequest awsreq = request.getOriginalRequest();
        this.setSdkTransactionId(request);
        this.setUserAgent(request);
        ProgressListener listener = awsreq.getGeneralProgressListener();
        Map<String, String> customHeaders = awsreq.getCustomRequestHeaders();
        if (customHeaders != null) {
            request.getHeaders().putAll(customHeaders);
        }
        if ((customQueryParams = awsreq.getCustomQueryParameters()) != null) {
            this.mergeQueryParameters(request, customQueryParams);
        }
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Response<T> response = null;
        InputStream origContent = request.getContent();
        InputStream toBeClosed = this.beforeRequest(request);
        InputStream notCloseable = toBeClosed == null ? null : (InputStream)ReleasableInputStream.wrap(toBeClosed).disableClose();
        request.setContent(notCloseable);
        try {
            SDKProgressPublisher.publishProgress(listener, ProgressEventType.CLIENT_REQUEST_STARTED_EVENT);
            response = this.executeHelper(request, responseHandler, errorResponseHandler, executionContext, requestHandler2s);
            SDKProgressPublisher.publishProgress(listener, ProgressEventType.CLIENT_REQUEST_SUCCESS_EVENT);
            TimingInfo timingInfo = awsRequestMetrics.getTimingInfo().endTiming();
            this.afterResponse(request, requestHandler2s, response, timingInfo);
            Response<T> response2 = response;
            return response2;
        }
        catch (AmazonClientException e) {
            SDKProgressPublisher.publishProgress(listener, ProgressEventType.CLIENT_REQUEST_FAILED_EVENT);
            this.afterError(request, response, requestHandler2s, e);
            throw e;
        }
        finally {
            IOUtils.closeQuietly(toBeClosed, log);
            request.setContent(origContent);
        }
    }

    private RuntimeException handleInterruptedException(ExecutionContext executionContext, InterruptedException e) {
        if (e instanceof SdkInterruptedException && ((SdkInterruptedException)e).getResponse() != null) {
            ((SdkInterruptedException)e).getResponse().getHttpResponse().getHttpRequest().abort();
        }
        if (executionContext.getClientExecutionTrackerTask().hasTimeoutExpired()) {
            Thread.interrupted();
            return new ClientExecutionTimeoutException();
        }
        Thread.currentThread().interrupt();
        return new AmazonClientException(e);
    }

    private RuntimeException handleAbortedException(ExecutionContext executionContext, AbortedException ae) {
        if (executionContext.getClientExecutionTrackerTask().hasTimeoutExpired()) {
            return new ClientExecutionTimeoutException();
        }
        return ae;
    }

    private void checkInterrupted() throws InterruptedException {
        this.checkInterrupted(null);
    }

    private void checkInterrupted(Response<?> response) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new SdkInterruptedException(response);
        }
    }

    private void mergeQueryParameters(Request<?> request, Map<String, List<String>> params) {
        Map<String, List<String>> existingParams = request.getParameters();
        for (Map.Entry<String, List<String>> param : params.entrySet()) {
            String pName = param.getKey();
            List<String> pValues = param.getValue();
            existingParams.put(pName, CollectionUtils.mergeLists(existingParams.get(pName), pValues));
        }
    }

    private InputStream beforeRequest(Request<?> request) {
        InputStream content;
        AmazonWebServiceRequest awsreq;
        block9: {
            awsreq = request.getOriginalRequest();
            ProgressListener listener = awsreq.getGeneralProgressListener();
            Map<String, String> headers = request.getHeaders();
            String s = headers.get("Content-Length");
            if (s != null) {
                try {
                    long contentLength = Long.parseLong(s);
                    SDKProgressPublisher.publishRequestContentLength(listener, contentLength);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)"Cannot parse the Content-Length header of the request.");
                }
            }
            if ((content = request.getContent()) == null) {
                return null;
            }
            if (!content.markSupported() && content instanceof FileInputStream) {
                try {
                    content = new ResettableInputStream((FileInputStream)content);
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block9;
                    log.debug((Object)"For the record; ignore otherwise", (Throwable)e);
                }
            }
        }
        if (!content.markSupported()) {
            content = new SdkBufferedInputStream(content);
        }
        InputStream is = ProgressInputStream.inputStreamForRequest(content, awsreq);
        if (unreliableTestConfig == null) {
            return is;
        }
        return new UnreliableFilterInputStream(is, unreliableTestConfig.isFakeIOException()).withBytesReadBeforeException(unreliableTestConfig.getBytesReadBeforeException()).withMaxNumErrors(unreliableTestConfig.getMaxNumErrors()).withResetIntervalBeforeException(unreliableTestConfig.getResetIntervalBeforeException());
    }

    private void afterError(Request<?> request, Response<?> response, List<RequestHandler2> requestHandler2s, AmazonClientException e) throws InterruptedException {
        for (RequestHandler2 handler2 : requestHandler2s) {
            handler2.afterError(request, response, e);
            this.checkInterrupted(response);
        }
    }

    private <T> void afterResponse(Request<?> request, List<RequestHandler2> requestHandler2s, Response<T> response, TimingInfo timingInfo) throws InterruptedException {
        for (RequestHandler2 handler2 : requestHandler2s) {
            handler2.afterResponse(request, response);
            this.checkInterrupted(response);
        }
    }

    private List<RequestHandler2> requestHandler2s(Request<?> request, ExecutionContext executionContext) {
        List<RequestHandler2> requestHandler2s = executionContext.getRequestHandler2s();
        if (requestHandler2s == null) {
            return Collections.emptyList();
        }
        for (RequestHandler2 requestHandler2 : requestHandler2s) {
            if (requestHandler2 instanceof CredentialsRequestHandler) {
                ((CredentialsRequestHandler)requestHandler2).setCredentials(executionContext.getCredentialsProvider().getCredentials());
            }
            requestHandler2.beforeRequest(request);
        }
        return requestHandler2s;
    }

    private <T> Response<T> executeHelper(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpResponseHandler<AmazonServiceException> errorResponseHandler, ExecutionContext executionContext, List<RequestHandler2> requestHandlers) throws InterruptedException {
        int readLimit;
        AmazonWebServiceRequest awsreq;
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics().addPropertyWith(AWSRequestMetrics.Field.ServiceName, (Object)request.getServiceName()).addPropertyWith(AWSRequestMetrics.Field.ServiceEndpoint, (Object)request.getEndpoint());
        LinkedHashMap<String, List<String>> originalParameters = new LinkedHashMap<String, List<String>>(request.getParameters());
        HashMap<String, String> originalHeaders = new HashMap<String, String>(request.getHeaders());
        ExecOneRequestParams execOneParams = new ExecOneRequestParams();
        InputStream originalContent = request.getContent();
        if (originalContent != null && originalContent.markSupported() && !(originalContent instanceof BufferedInputStream)) {
            awsreq = request.getOriginalRequest();
            readLimit = awsreq.getRequestClientOptions().getReadLimit();
            originalContent.mark(readLimit);
        }
        while (true) {
            this.checkInterrupted();
            if (originalContent instanceof BufferedInputStream && originalContent.markSupported()) {
                awsreq = request.getOriginalRequest();
                readLimit = awsreq.getRequestClientOptions().getReadLimit();
                originalContent.mark(readLimit);
            }
            execOneParams.initPerRetry();
            if (execOneParams.redirectedURI != null) {
                String scheme = execOneParams.redirectedURI.getScheme();
                String beforeAuthority = scheme == null ? "" : scheme + "://";
                String authority = execOneParams.redirectedURI.getAuthority();
                String path = execOneParams.redirectedURI.getPath();
                request.setEndpoint(URI.create(beforeAuthority + authority));
                request.setResourcePath(path);
            }
            if (execOneParams.authRetryParam != null) {
                request.setEndpoint(execOneParams.authRetryParam.getEndpointForRetry());
            }
            awsRequestMetrics.setCounter(AWSRequestMetrics.Field.RequestCount, (long)execOneParams.requestCount);
            if (execOneParams.isRetry()) {
                request.setParameters(originalParameters);
                request.setHeaders(originalHeaders);
                request.setContent(originalContent);
            }
            try {
                Response<T> response = this.executeOneRequest(request, responseHandler, errorResponseHandler, executionContext, awsRequestMetrics, execOneParams, requestHandlers);
                if (response == null) continue;
                Response<T> beforeAuthority = response;
                return beforeAuthority;
            }
            catch (IOException ioe) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Unable to execute HTTP request: " + ioe.getMessage()), (Throwable)ioe);
                }
                this.captureExceptionMetrics(ioe, awsRequestMetrics);
                awsRequestMetrics.addProperty(AWSRequestMetrics.Field.AWSRequestID, null);
                AmazonClientException ace = new AmazonClientException("Unable to execute HTTP request: " + ioe.getMessage(), ioe);
                if (!this.shouldRetry(request.getOriginalRequest(), execOneParams, ace, executionContext)) {
                    throw this.lastReset(ace, request);
                }
                execOneParams.retriedException = ace;
                continue;
            }
            catch (RuntimeException e) {
                throw this.lastReset(this.captureExceptionMetrics(e, awsRequestMetrics), request);
            }
            catch (Error e) {
                throw this.lastReset(this.captureExceptionMetrics(e, awsRequestMetrics), request);
            }
            finally {
                HttpEntity entity;
                if (execOneParams.leaveHttpConnectionOpen || execOneParams.apacheResponse == null || (entity = execOneParams.apacheResponse.getEntity()) == null) continue;
                try {
                    IOUtils.closeQuietly(entity.getContent(), log);
                }
                catch (IOException e) {
                    log.warn((Object)"Cannot close the response content.", (Throwable)e);
                }
                continue;
            }
            break;
        }
    }

    private <T extends Throwable> T lastReset(T t, Request<?> req) {
        try {
            InputStream content = req.getContent();
            if (content != null && content.markSupported()) {
                content.reset();
            }
        }
        catch (Exception ex) {
            log.debug((Object)"FYI: failed to reset content inputstream before throwing up", (Throwable)ex);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AWSCredentials getCredentialsFromContext(ExecutionContext executionContext, AWSRequestMetrics requestMetrics) {
        AWSCredentialsProvider credentialsProvider = executionContext.getCredentialsProvider();
        AWSCredentials credentials = null;
        if (credentialsProvider != null) {
            requestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
            try {
                credentials = credentialsProvider.getCredentials();
            }
            finally {
                requestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
            }
        }
        return credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Response<T> executeOneRequest(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpResponseHandler<AmazonServiceException> errorResponseHandler, ExecutionContext execContext, AWSRequestMetrics awsRequestMetrics, ExecOneRequestParams execOneParams, List<RequestHandler2> requestHandlers) throws IOException, InterruptedException {
        int statusCode;
        boolean isHeaderReqIdAvail;
        if (execOneParams.isRetry()) {
            this.resetRequestInputStream(request);
        }
        this.checkInterrupted();
        if (requestLog.isDebugEnabled()) {
            requestLog.debug((Object)("Sending Request: " + request));
        }
        AWSCredentials credentials = this.getCredentialsFromContext(execContext, awsRequestMetrics);
        AmazonWebServiceRequest awsreq = request.getOriginalRequest();
        ProgressListener listener = awsreq.getGeneralProgressListener();
        if (execOneParams.isRetry()) {
            this.pauseBeforeRetry(request, awsRequestMetrics, execOneParams, listener);
        }
        this.updateRetryHeaderInfo(request, execOneParams);
        execOneParams.newSigner(request, execContext);
        if (execOneParams.signer != null && credentials != null) {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestSigningTime);
            try {
                if (this.timeOffset != 0) {
                    request.setTimeOffset(this.timeOffset);
                }
                execOneParams.signer.sign(request, credentials);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestSigningTime);
            }
        }
        this.checkInterrupted();
        execOneParams.newApacheRequest(this.httpRequestFactory, request, this.httpClientSettings);
        this.captureConnectionPoolMetrics(awsRequestMetrics);
        HttpClientContext localRequestContext = ApacheUtils.newClientContext(this.httpClientSettings, ImmutableMapParameter.of(AWSRequestMetrics.class.getSimpleName(), awsRequestMetrics));
        execOneParams.resetBeforeHttpRequest();
        SDKProgressPublisher.publishProgress(listener, ProgressEventType.HTTP_REQUEST_STARTED_EVENT);
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.HttpRequestTime);
        awsRequestMetrics.setCounter(AWSRequestMetrics.Field.RetryCapacityConsumed, (long)this.retryCapacity.consumedCapacity());
        execContext.getClientExecutionTrackerTask().setCurrentHttpRequest(execOneParams.apacheRequest);
        HttpRequestAbortTaskTracker requestAbortTaskTracker = this.httpRequestTimer.startTimer(execOneParams.apacheRequest, this.getRequestTimeout(awsreq));
        try {
            execOneParams.apacheResponse = this.httpClient.execute((HttpUriRequest)execOneParams.apacheRequest, (HttpContext)localRequestContext);
            if (this.shouldBufferHttpEntity(responseHandler.needsConnectionLeftOpen(), execContext, execOneParams, requestAbortTaskTracker)) {
                execOneParams.apacheResponse.setEntity((HttpEntity)new BufferedHttpEntity(execOneParams.apacheResponse.getEntity()));
            }
            isHeaderReqIdAvail = this.logHeaderRequestId(execOneParams.apacheResponse);
        }
        catch (IOException ioe) {
            if (execContext.getClientExecutionTrackerTask().hasTimeoutExpired()) {
                throw new InterruptedException();
            }
            if (requestAbortTaskTracker.httpRequestAborted()) {
                throw new HttpRequestTimeoutException(ioe);
            }
            throw ioe;
        }
        finally {
            requestAbortTaskTracker.cancelTask();
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.HttpRequestTime);
        }
        SDKProgressPublisher.publishProgress(listener, ProgressEventType.HTTP_REQUEST_COMPLETED_EVENT);
        StatusLine statusLine = execOneParams.apacheResponse.getStatusLine();
        int n = statusCode = statusLine == null ? -1 : statusLine.getStatusCode();
        if (this.isRequestSuccessful(execOneParams.apacheResponse)) {
            awsRequestMetrics.addProperty(AWSRequestMetrics.Field.StatusCode, (Object)statusCode);
            execOneParams.leaveHttpConnectionOpen = responseHandler.needsConnectionLeftOpen();
            HttpResponse httpResponse = this.createResponse(execOneParams.apacheRequest, request, execOneParams.apacheResponse);
            T response = this.handleResponse(request, responseHandler, execOneParams.apacheRequest, httpResponse, execOneParams.apacheResponse, execContext, isHeaderReqIdAvail, requestHandlers);
            if (execOneParams.isRetry() && execContext.retryCapacityConsumed()) {
                this.retryCapacity.release(5);
            } else {
                this.retryCapacity.release();
            }
            return new Response<T>(response, httpResponse);
        }
        if (AmazonHttpClient.isTemporaryRedirect(execOneParams.apacheResponse)) {
            Header[] locationHeaders = execOneParams.apacheResponse.getHeaders("location");
            String redirectedLocation = locationHeaders[0].getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Redirecting to: " + redirectedLocation));
            }
            execOneParams.redirectedURI = URI.create(redirectedLocation);
            awsRequestMetrics.addPropertyWith(AWSRequestMetrics.Field.StatusCode, (Object)statusCode).addPropertyWith(AWSRequestMetrics.Field.RedirectLocation, (Object)redirectedLocation).addPropertyWith(AWSRequestMetrics.Field.AWSRequestID, null);
            return null;
        }
        execOneParams.leaveHttpConnectionOpen = errorResponseHandler.needsConnectionLeftOpen();
        AmazonServiceException ase = this.handleErrorResponse(request, errorResponseHandler, execOneParams.apacheRequest, execOneParams.apacheResponse);
        awsRequestMetrics.addPropertyWith(AWSRequestMetrics.Field.AWSRequestID, (Object)ase.getRequestId()).addPropertyWith(AWSRequestMetrics.Field.AWSErrorCode, (Object)ase.getErrorCode()).addPropertyWith(AWSRequestMetrics.Field.StatusCode, (Object)ase.getStatusCode());
        execOneParams.authRetryParam = null;
        AuthErrorRetryStrategy authRetry = execContext.getAuthErrorRetryStrategy();
        if (authRetry != null) {
            HttpResponse httpResponse = this.createResponse(execOneParams.apacheRequest, request, execOneParams.apacheResponse);
            execOneParams.authRetryParam = authRetry.shouldRetryWithAuthParam(request, httpResponse, ase);
        }
        if (execOneParams.authRetryParam == null && !this.shouldRetry(request.getOriginalRequest(), execOneParams, ase, execContext)) {
            throw ase;
        }
        if (RetryUtils.isThrottlingException(ase)) {
            awsRequestMetrics.incrementCounterWith(AWSRequestMetrics.Field.ThrottleException).addProperty(AWSRequestMetrics.Field.ThrottleException, (Object)ase);
        }
        execOneParams.retriedException = ase;
        if (RetryUtils.isClockSkewError(ase)) {
            int clockSkew;
            this.timeOffset = clockSkew = this.parseClockSkewOffset(execOneParams.apacheResponse, ase);
            SDKGlobalTime.setGlobalTimeOffset(this.timeOffset);
            request.setTimeOffset(this.timeOffset);
        }
        return null;
    }

    private void resetRequestInputStream(Request<?> request) throws ResetException {
        InputStream requestInputStream = request.getContent();
        if (requestInputStream != null && requestInputStream.markSupported()) {
            try {
                requestInputStream.reset();
            }
            catch (IOException ex) {
                throw new ResetException("Failed to reset the request input stream", ex);
            }
        }
    }

    private boolean shouldBufferHttpEntity(boolean needsConnectionLeftOpen, ExecutionContext execContext, ExecOneRequestParams execParams, HttpRequestAbortTaskTracker requestAbortTaskTracker) {
        return (execContext.getClientExecutionTrackerTask().isEnabled() || requestAbortTaskTracker.isEnabled()) && !needsConnectionLeftOpen && execParams.apacheResponse.getEntity() != null;
    }

    private boolean logHeaderRequestId(org.apache.http.HttpResponse res) {
        boolean isHeaderReqIdAvail;
        Header reqIdHeader = res.getFirstHeader("x-amzn-RequestId");
        boolean bl = isHeaderReqIdAvail = reqIdHeader != null;
        if (requestIdLog.isDebugEnabled() || requestLog.isDebugEnabled()) {
            String msg = "x-amzn-RequestId: " + (isHeaderReqIdAvail ? reqIdHeader.getValue() : "not available");
            if (requestIdLog.isDebugEnabled()) {
                requestIdLog.debug((Object)msg);
            } else {
                requestLog.debug((Object)msg);
            }
        }
        return isHeaderReqIdAvail;
    }

    private void logResponseRequestId(String awsRequestId) {
        if (requestIdLog.isDebugEnabled() || requestLog.isDebugEnabled()) {
            String msg = "AWS Request ID: " + (awsRequestId == null ? "not available" : awsRequestId);
            if (requestIdLog.isDebugEnabled()) {
                requestIdLog.debug((Object)msg);
            } else {
                requestLog.debug((Object)msg);
            }
        }
    }

    private void captureConnectionPoolMetrics(AWSRequestMetrics awsRequestMetrics) {
        if (awsRequestMetrics.isEnabled() && this.httpClient.getHttpClientConnectionManager() instanceof ConnPoolControl) {
            ConnPoolControl control = (ConnPoolControl)this.httpClient.getHttpClientConnectionManager();
            awsRequestMetrics.withCounter(AWSRequestMetrics.Field.HttpClientPoolAvailableCount, (long)control.getTotalStats().getAvailable()).withCounter(AWSRequestMetrics.Field.HttpClientPoolLeasedCount, (long)control.getTotalStats().getLeased()).withCounter(AWSRequestMetrics.Field.HttpClientPoolPendingCount, (long)control.getTotalStats().getPending());
        }
    }

    private <T extends Throwable> T captureExceptionMetrics(T t, AWSRequestMetrics awsRequestMetrics) {
        AmazonServiceException ase;
        awsRequestMetrics.incrementCounterWith(AWSRequestMetrics.Field.Exception).addProperty(AWSRequestMetrics.Field.Exception, t);
        if (t instanceof AmazonServiceException && RetryUtils.isThrottlingException(ase = (AmazonServiceException)t)) {
            awsRequestMetrics.incrementCounterWith(AWSRequestMetrics.Field.ThrottleException).addProperty(AWSRequestMetrics.Field.ThrottleException, (Object)ase);
        }
        return t;
    }

    private void setSdkTransactionId(Request<?> request) {
        request.addHeader(HEADER_SDK_TRANSACTION_ID, UUID.randomUUID().toString());
    }

    private void setUserAgent(Request<?> request) {
        String userAgentMarker;
        AmazonWebServiceRequest awsreq;
        RequestClientOptions opts;
        String userAgent = this.config.getUserAgent();
        if (!userAgent.equals(ClientConfiguration.DEFAULT_USER_AGENT)) {
            userAgent = userAgent + ", " + ClientConfiguration.DEFAULT_USER_AGENT;
        }
        if (userAgent != null) {
            request.addHeader(HEADER_USER_AGENT, userAgent);
        }
        if ((opts = (awsreq = request.getOriginalRequest()).getRequestClientOptions()) != null && (userAgentMarker = opts.getClientMarker(RequestClientOptions.Marker.USER_AGENT)) != null) {
            request.addHeader(HEADER_USER_AGENT, AmazonHttpClient.createUserAgentString(userAgent, userAgentMarker));
        }
    }

    private void updateRetryHeaderInfo(Request<?> request, ExecOneRequestParams execOneRequestParams) {
        int availableRetryCapacity = this.retryCapacity.availableCapacity();
        String headerValue = String.format("%s/%s/%s", execOneRequestParams.requestCount - 1, execOneRequestParams.lastBackoffDelay, availableRetryCapacity >= 0 ? Integer.valueOf(availableRetryCapacity) : "");
        request.addHeader(HEADER_SDK_RETRY_INFO, headerValue);
    }

    public void shutdown() {
        this.clientExecutionTimer.shutdown();
        this.httpRequestTimer.shutdown();
        IdleConnectionReaper.removeConnectionManager(this.httpClient.getHttpClientConnectionManager());
        this.httpClient.getHttpClientConnectionManager().shutdown();
    }

    private boolean shouldRetry(AmazonWebServiceRequest originalRequest, ExecOneRequestParams params, AmazonClientException exception, ExecutionContext executionContext) {
        HttpEntity entity;
        int retries = params.requestCount - 1;
        RetryPolicy retryPolicy = this.config.getRetryPolicy();
        HttpRequestBase method = params.apacheRequest;
        int maxErrorRetry = this.config.getMaxErrorRetry();
        if (maxErrorRetry < 0 || !retryPolicy.isMaxErrorRetryInClientConfigHonored()) {
            maxErrorRetry = retryPolicy.getMaxErrorRetry();
        }
        if (retries >= maxErrorRetry) {
            return false;
        }
        if (method instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)method).getEntity()) != null && !entity.isRepeatable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Entity not repeatable");
            }
            return false;
        }
        if (!(exception instanceof AmazonServiceException) || !RetryUtils.isThrottlingException((AmazonServiceException)exception)) {
            if (!this.retryCapacity.acquire(5)) {
                return false;
            }
            executionContext.markRetryCapacityConsumed();
        }
        if (!retryPolicy.getRetryCondition().shouldRetry(originalRequest, exception, retries)) {
            if (executionContext.retryCapacityConsumed()) {
                this.retryCapacity.release(5);
            }
            return false;
        }
        return true;
    }

    private boolean isRequestSuccessful(org.apache.http.HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        return status / 100 == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T handleResponse(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpRequestBase method, HttpResponse httpResponse, org.apache.http.HttpResponse apacheHttpResponse, ExecutionContext executionContext, boolean isHeaderReqIdAvail, List<RequestHandler2> requestHandlers) throws IOException, InterruptedException {
        AmazonWebServiceRequest awsreq = request.getOriginalRequest();
        ProgressListener listener = awsreq.getGeneralProgressListener();
        try {
            AmazonWebServiceResponse<T> awsResponse;
            Map<String, String> headers;
            String s;
            CountingInputStream countingInputStream = null;
            InputStream is = httpResponse.getContent();
            if (is != null) {
                if (System.getProperty("com.amazonaws.sdk.enableRuntimeProfiling") != null) {
                    countingInputStream = new CountingInputStream(is);
                    is = countingInputStream;
                    httpResponse.setContent(is);
                }
                httpResponse.setContent(ProgressInputStream.inputStreamForResponse(is, awsreq));
            }
            if ((s = (headers = httpResponse.getHeaders()).get("Content-Length")) != null) {
                try {
                    long contentLength = Long.parseLong(s);
                    SDKProgressPublisher.publishResponseContentLength(listener, contentLength);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)"Cannot parse the Content-Length header of the response.");
                }
            }
            AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ResponseProcessingTime);
            SDKProgressPublisher.publishProgress(listener, ProgressEventType.HTTP_RESPONSE_STARTED_EVENT);
            try {
                awsResponse = responseHandler.handle(this.beforeUnmarshalling(requestHandlers, request, httpResponse));
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.ResponseProcessingTime);
            }
            SDKProgressPublisher.publishProgress(listener, ProgressEventType.HTTP_RESPONSE_COMPLETED_EVENT);
            if (countingInputStream != null) {
                awsRequestMetrics.setCounter(AWSRequestMetrics.Field.BytesProcessed, countingInputStream.getByteCount());
            }
            if (awsResponse == null) {
                throw new RuntimeException("Unable to unmarshall response metadata. Response Code: " + httpResponse.getStatusCode() + ", Response Text: " + httpResponse.getStatusText());
            }
            AmazonWebServiceRequest userRequest = request.getOriginalRequest();
            if (userRequest.getCloneRoot() != null) {
                userRequest = userRequest.getCloneRoot();
            }
            this.responseMetadataCache.add(userRequest, awsResponse.getResponseMetadata());
            String awsRequestId = awsResponse.getRequestId();
            if (requestLog.isDebugEnabled()) {
                StatusLine statusLine = apacheHttpResponse.getStatusLine();
                requestLog.debug((Object)("Received successful response: " + (statusLine == null ? null : Integer.valueOf(statusLine.getStatusCode())) + ", AWS Request ID: " + awsRequestId));
            }
            if (!isHeaderReqIdAvail) {
                this.logResponseRequestId(awsRequestId);
            }
            awsRequestMetrics.addProperty(AWSRequestMetrics.Field.AWSRequestID, (Object)awsRequestId);
            return awsResponse.getResult();
        }
        catch (CRC32MismatchException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (AmazonClientException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = "Unable to unmarshall response (" + e.getMessage() + "). Response Code: " + httpResponse.getStatusCode() + ", Response Text: " + httpResponse.getStatusText();
            throw new AmazonClientException(errorMessage, e);
        }
    }

    private HttpResponse beforeUnmarshalling(List<RequestHandler2> requestHandler2s, Request<?> request, HttpResponse origHttpResponse) {
        HttpResponse toReturn = origHttpResponse;
        for (RequestHandler2 requestHandler : requestHandler2s) {
            toReturn = requestHandler.beforeUnmarshalling(request, toReturn);
        }
        return toReturn;
    }

    private AmazonServiceException handleErrorResponse(Request<?> request, HttpResponseHandler<AmazonServiceException> errorResponseHandler, HttpRequestBase method, org.apache.http.HttpResponse apacheHttpResponse) throws IOException, InterruptedException {
        String reasonPhrase;
        int statusCode;
        StatusLine statusLine = apacheHttpResponse.getStatusLine();
        if (statusLine == null) {
            statusCode = -1;
            reasonPhrase = null;
        } else {
            statusCode = statusLine.getStatusCode();
            reasonPhrase = statusLine.getReasonPhrase();
        }
        HttpResponse response = this.createResponse(method, request, apacheHttpResponse);
        AmazonServiceException exception = null;
        try {
            exception = errorResponseHandler.handle(response);
            if (requestLog.isDebugEnabled()) {
                requestLog.debug((Object)("Received error response: " + exception));
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            if (statusCode == 413) {
                exception = new AmazonServiceException("Request entity too large");
                exception.setServiceName(request.getServiceName());
                exception.setStatusCode(statusCode);
                exception.setErrorType(AmazonServiceException.ErrorType.Client);
                exception.setErrorCode("Request entity too large");
            }
            if (statusCode >= 500 && statusCode < 600) {
                exception = new AmazonServiceException(reasonPhrase);
                exception.setServiceName(request.getServiceName());
                exception.setStatusCode(statusCode);
                exception.setErrorType(AmazonServiceException.ErrorType.Service);
                exception.setErrorCode(reasonPhrase);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            String errorMessage = "Unable to unmarshall error response (" + e.getMessage() + "). Response Code: " + (statusLine == null ? "None" : Integer.valueOf(statusCode)) + ", Response Text: " + reasonPhrase;
            throw new AmazonClientException(errorMessage, e);
        }
        exception.setStatusCode(statusCode);
        exception.setServiceName(request.getServiceName());
        exception.fillInStackTrace();
        return exception;
    }

    private HttpResponse createResponse(HttpRequestBase method, Request<?> request, org.apache.http.HttpResponse apacheHttpResponse) throws IOException {
        HttpResponse httpResponse = new HttpResponse(request, method);
        if (apacheHttpResponse.getEntity() != null) {
            httpResponse.setContent(apacheHttpResponse.getEntity().getContent());
        }
        httpResponse.setStatusCode(apacheHttpResponse.getStatusLine().getStatusCode());
        httpResponse.setStatusText(apacheHttpResponse.getStatusLine().getReasonPhrase());
        for (Header header : apacheHttpResponse.getAllHeaders()) {
            httpResponse.addHeader(header.getName(), header.getValue());
        }
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pauseBeforeRetry(Request<?> request, AWSRequestMetrics awsRequestMetrics, ExecOneRequestParams execOneParams, ProgressListener listener) throws InterruptedException {
        SDKProgressPublisher.publishProgress(listener, ProgressEventType.CLIENT_REQUEST_RETRY_EVENT);
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RetryPauseTime);
        try {
            if (execOneParams.retriedException != null) {
                this.doPauseBeforeRetry(request.getOriginalRequest(), execOneParams.retriedException, execOneParams.requestCount, this.config.getRetryPolicy(), execOneParams);
            }
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RetryPauseTime);
        }
    }

    private void doPauseBeforeRetry(AmazonWebServiceRequest originalRequest, AmazonClientException previousException, int requestCount, RetryPolicy retryPolicy, ExecOneRequestParams execOneParams) throws InterruptedException {
        long delay;
        int retries = requestCount - 1 - 1;
        execOneParams.lastBackoffDelay = delay = retryPolicy.getBackoffStrategy().delayBeforeNextRetry(originalRequest, previousException, retries);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retriable error detected, will retry in " + delay + "ms, attempt number: " + retries));
        }
        Thread.sleep(delay);
    }

    private String getServerDateFromException(String body) {
        int startPos = body.indexOf("(");
        int endPos = body.indexOf(" + ");
        if (endPos == -1) {
            endPos = body.indexOf(" - ");
        }
        return endPos == -1 ? null : body.substring(startPos + 1, endPos);
    }

    private int parseClockSkewOffset(org.apache.http.HttpResponse response, AmazonServiceException exception) {
        long currentTimeMilli = System.currentTimeMillis();
        Date serverDate = null;
        String serverDateStr = null;
        Header[] responseDateHeader = response.getHeaders("Date");
        try {
            if (responseDateHeader.length == 0) {
                String errmsg = exception.getMessage();
                serverDateStr = this.getServerDateFromException(errmsg);
                if (serverDateStr == null) {
                    log.warn((Object)("Unable to parse clock skew offset from errmsg: " + errmsg));
                    return 0;
                }
                serverDate = DateUtils.parseCompressedISO8601Date(serverDateStr);
            } else {
                serverDateStr = responseDateHeader[0].getValue();
                serverDate = DateUtils.parseRFC822Date(serverDateStr);
            }
        }
        catch (RuntimeException e) {
            log.warn((Object)("Unable to parse clock skew offset from response: " + serverDateStr), (Throwable)e);
            return 0;
        }
        long diff = currentTimeMilli - serverDate.getTime();
        return (int)(diff / 1000L);
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    public int getTimeOffset() {
        return this.timeOffset;
    }

    private int getRequestTimeout(AmazonWebServiceRequest request) {
        if (request.getSdkRequestTimeout() != null) {
            return request.getSdkRequestTimeout();
        }
        return this.config.getRequestTimeout();
    }

    private int getClientExecutionTimeout(AmazonWebServiceRequest request) {
        if (request.getSdkClientExecutionTimeout() != null) {
            return request.getSdkClientExecutionTimeout();
        }
        return this.config.getClientExecutionTimeout();
    }

    static {
        String jvmVersion;
        log = LogFactory.getLog(AmazonHttpClient.class);
        requestIdLog = LogFactory.getLog((String)"com.amazonaws.requestId");
        requestLog = LogFactory.getLog((String)"com.amazonaws.request");
        httpClientFactory = new ApacheHttpClientFactory();
        List<String> problematicJvmVersions = Arrays.asList("1.6.0_06", "1.6.0_13", "1.6.0_17", "1.6.0_65", "1.7.0_45");
        if (problematicJvmVersions.contains(jvmVersion = System.getProperty("java.version"))) {
            log.warn((Object)("Detected a possible problem with the current JVM version (" + jvmVersion + ").  " + "If you experience XML parsing problems using the SDK, try upgrading to a more recent JVM update."));
        }
    }

    private static class ExecOneRequestParams {
        int requestCount;
        long lastBackoffDelay = 0L;
        AmazonClientException retriedException;
        HttpRequestBase apacheRequest;
        org.apache.http.HttpResponse apacheResponse;
        URI redirectedURI;
        AuthRetryParameters authRetryParam;
        boolean leaveHttpConnectionOpen;
        private Signer signer;
        private URI signerURI;

        private ExecOneRequestParams() {
        }

        boolean isRetry() {
            return this.requestCount > 1 || this.redirectedURI != null || this.authRetryParam != null;
        }

        void initPerRetry() {
            ++this.requestCount;
            this.apacheRequest = null;
            this.apacheResponse = null;
            this.leaveHttpConnectionOpen = false;
        }

        Signer newSigner(Request<?> request, ExecutionContext execContext) {
            if (this.authRetryParam != null) {
                this.signerURI = this.authRetryParam.getEndpointForRetry();
                this.signer = this.authRetryParam.getSignerForRetry();
                execContext.setSigner(this.signer);
            } else if (this.redirectedURI != null && !this.redirectedURI.equals(this.signerURI)) {
                this.signerURI = this.redirectedURI;
                this.signer = execContext.getSignerByURI(this.signerURI);
            } else if (this.signer == null) {
                this.signerURI = request.getEndpoint();
                this.signer = execContext.getSignerByURI(this.signerURI);
            }
            return this.signer;
        }

        HttpRequestBase newApacheRequest(HttpRequestFactory<HttpRequestBase> httpRequestFactory, Request<?> request, HttpClientSettings options) throws IOException {
            this.apacheRequest = httpRequestFactory.create(request, options);
            if (this.redirectedURI != null) {
                this.apacheRequest.setURI(this.redirectedURI);
            }
            return this.apacheRequest;
        }

        void resetBeforeHttpRequest() {
            this.retriedException = null;
            this.authRetryParam = null;
            this.redirectedURI = null;
        }
    }
}

