/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.commit.CommitSequence;
import org.apache.gobblin.commit.CommitSequenceStore;
import org.apache.gobblin.commit.CommitStep;
import org.apache.gobblin.commit.DeliverySemantics;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.event.FailureEventBuilder;
import org.apache.gobblin.metrics.event.lineage.LineageInfo;
import org.apache.gobblin.publisher.CommitSequencePublisher;
import org.apache.gobblin.publisher.DataPublisher;
import org.apache.gobblin.publisher.DataPublisherFactory;
import org.apache.gobblin.publisher.UnpublishedHandling;
import org.apache.gobblin.runtime.JobContext;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.TaskState;
import org.apache.gobblin.runtime.commit.DatasetStateCommitStep;
import org.apache.gobblin.runtime.task.TaskFactory;
import org.apache.gobblin.runtime.task.TaskUtils;
import org.apache.gobblin.source.extractor.JobCommitPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SafeDatasetCommit
implements Callable<Void> {
    private static final Logger log = LoggerFactory.getLogger(SafeDatasetCommit.class);
    private static final Object GLOBAL_LOCK = new Object();
    private static final String DATASET_STATE = "datasetState";
    private static final String FAILED_DATASET_EVENT = "failedDataset";
    private final boolean shouldCommitDataInJob;
    private final boolean isJobCancelled;
    private final DeliverySemantics deliverySemantics;
    private final String datasetUrn;
    private final JobState.DatasetState datasetState;
    private final boolean isMultithreaded;
    private final JobContext jobContext;
    private MetricContext metricContext;

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Void call() throws Exception {
        Class dataPublisherClass;
        if (this.datasetState.getState() == JobState.RunningState.COMMITTED) {
            log.info(this.datasetUrn + " have been committed.");
            return null;
        }
        this.metricContext = Instrumented.getMetricContext((State)this.datasetState, SafeDatasetCommit.class);
        this.finalizeDatasetStateBeforeCommit(this.datasetState);
        try (Closer closer = Closer.create();){
            dataPublisherClass = (Class)JobContext.getJobDataPublisherClass((State)this.jobContext.getJobState()).or(Class.forName("org.apache.gobblin.publisher.BaseDataPublisher"));
            if (!this.canCommitDataset(this.datasetState)) {
                log.warn(String.format("Not committing dataset %s of job %s with commit policy %s and state %s", new Object[]{this.datasetUrn, this.jobContext.getJobId(), this.jobContext.getJobCommitPolicy(), this.datasetState.getState()}));
                this.checkForUnpublishedWUHandling(this.datasetUrn, this.datasetState, dataPublisherClass, closer);
                throw new RuntimeException(String.format("Not committing dataset %s of job %s with commit policy %s and state %s", new Object[]{this.datasetUrn, this.jobContext.getJobId(), this.jobContext.getJobCommitPolicy(), this.datasetState.getState()}));
            }
        }
        catch (ReflectiveOperationException roe) {
            log.error("Failed to instantiate data publisher for dataset %s of job %s.", new Object[]{this.datasetUrn, this.jobContext.getJobId(), roe});
            throw new RuntimeException(roe);
        }
        finally {
            this.maySubmitFailureEvent(this.datasetState);
        }
        if (this.isJobCancelled) {
            log.info("Executing commit steps although job is cancelled due to job commit policy: " + this.jobContext.getJobCommitPolicy());
        }
        Optional commitSequenceBuilder = Optional.absent();
        boolean canPersistStates = true;
        try (Closer closer = Closer.create();){
            if (this.shouldCommitDataInJob) {
                log.info(String.format("Committing dataset %s of job %s with commit policy %s and state %s", new Object[]{this.datasetUrn, this.jobContext.getJobId(), this.jobContext.getJobCommitPolicy(), this.datasetState.getState()}));
                ListMultimap<TaskFactoryWrapper, TaskState> taskStatesByFactory = this.groupByTaskFactory(this.datasetState);
                for (Map.Entry entry : taskStatesByFactory.asMap().entrySet()) {
                    DataPublisher publisher;
                    TaskFactory taskFactory = ((TaskFactoryWrapper)entry.getKey()).getTaskFactory();
                    if (this.deliverySemantics == DeliverySemantics.EXACTLY_ONCE) {
                        if (taskFactory != null) {
                            throw new RuntimeException("Custom task factories do not support exactly once delivery semantics.");
                        }
                        this.generateCommitSequenceBuilder(this.datasetState, (Collection)entry.getValue());
                        continue;
                    }
                    if (taskFactory == null) {
                        publisher = DataPublisherFactory.get((String)dataPublisherClass.getName(), (State)this.jobContext.getJobState(), this.jobContext.getJobBroker());
                        if (!DataPublisherFactory.isPublisherCacheable((DataPublisher)publisher)) {
                            closer.register((Closeable)publisher);
                        }
                    } else {
                        publisher = taskFactory.createDataPublisher(this.datasetState);
                    }
                    if (this.isJobCancelled) {
                        if (publisher.canBeSkipped()) {
                            log.warn(publisher.getClass() + " will be skipped.");
                            continue;
                        }
                        canPersistStates = false;
                        throw new RuntimeException("Cannot persist state upon cancellation because publisher has unfinished work and cannot be skipped.");
                    }
                    if (this.isMultithreaded && !publisher.isThreadSafe()) {
                        log.warn(String.format("Gobblin is set up to parallelize publishing, however the publisher %s is not thread-safe. Falling back to serial publishing.", publisher.getClass().getName()));
                        this.safeCommitDataset((Collection)entry.getValue(), publisher);
                        continue;
                    }
                    this.commitDataset((Collection)entry.getValue(), publisher);
                }
                this.datasetState.setState(JobState.RunningState.COMMITTED);
            } else if (this.datasetState.getState() == JobState.RunningState.SUCCESSFUL) {
                this.datasetState.setState(JobState.RunningState.COMMITTED);
            }
        }
        try {
            this.finalizeDatasetState(this.datasetState, this.datasetUrn);
            this.maySubmitFailureEvent(this.datasetState);
            this.maySubmitLineageEvent(this.datasetState);
            if (commitSequenceBuilder.isPresent()) {
                this.buildAndExecuteCommitSequence((CommitSequence.Builder)commitSequenceBuilder.get(), this.datasetState, this.datasetUrn);
                this.datasetState.setState(JobState.RunningState.COMMITTED);
                return null;
            }
            if (!canPersistStates) return null;
            this.persistDatasetState(this.datasetUrn, this.datasetState);
            return null;
        }
        catch (IOException | RuntimeException ioe) {
            log.error(String.format("Failed to persist dataset state for dataset %s of job %s", this.datasetUrn, this.jobContext.getJobId()), (Throwable)ioe);
            throw new RuntimeException(ioe);
        }
        catch (Throwable throwable) {
            try {
                log.error(String.format("Failed to commit dataset state for dataset %s of job %s", this.datasetUrn, this.jobContext.getJobId()), throwable);
                throw new RuntimeException(throwable);
            }
            catch (Throwable throwable2) {
                try {
                    this.finalizeDatasetState(this.datasetState, this.datasetUrn);
                    this.maySubmitFailureEvent(this.datasetState);
                    this.maySubmitLineageEvent(this.datasetState);
                    if (commitSequenceBuilder.isPresent()) {
                        this.buildAndExecuteCommitSequence((CommitSequence.Builder)commitSequenceBuilder.get(), this.datasetState, this.datasetUrn);
                        this.datasetState.setState(JobState.RunningState.COMMITTED);
                        throw throwable2;
                    } else {
                        if (!canPersistStates) throw throwable2;
                        this.persistDatasetState(this.datasetUrn, this.datasetState);
                    }
                    throw throwable2;
                }
                catch (IOException | RuntimeException ioe) {
                    log.error(String.format("Failed to persist dataset state for dataset %s of job %s", this.datasetUrn, this.jobContext.getJobId()), (Throwable)ioe);
                    throw new RuntimeException(ioe);
                }
            }
        }
    }

    private void maySubmitFailureEvent(JobState.DatasetState datasetState) {
        if (datasetState.getState() == JobState.RunningState.FAILED) {
            FailureEventBuilder failureEvent = new FailureEventBuilder(FAILED_DATASET_EVENT);
            failureEvent.addMetadata(DATASET_STATE, datasetState.toString());
            failureEvent.submit(this.metricContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maySubmitLineageEvent(JobState.DatasetState datasetState) {
        List<TaskState> allStates = datasetState.getTaskStates();
        ArrayList states = Lists.newArrayList();
        for (TaskState taskState : allStates) {
            if (taskState.getWorkingState() != WorkUnitState.WorkingState.COMMITTED || !LineageInfo.hasLineageInfo((State)taskState)) continue;
            states.add(taskState);
        }
        if (states.size() == 0) {
            log.info("Will not submit lineage events as no state contains lineage info");
            return;
        }
        try {
            if (StringUtils.isEmpty((String)this.datasetUrn)) {
                for (Map.Entry entry : SafeDatasetCommit.aggregateByLineageEvent(states).entrySet()) {
                    this.submitLineageEvent((String)entry.getKey(), (Collection)entry.getValue());
                }
            } else {
                this.submitLineageEvent(this.datasetUrn, states);
            }
        }
        finally {
            for (TaskState taskState : allStates) {
                LineageInfo.purgeLineageInfo((State)taskState);
            }
        }
    }

    private void submitLineageEvent(String dataset, Collection<TaskState> states) {
        Collection events = LineageInfo.load(states);
        events.forEach(event -> event.submit(this.metricContext));
        log.info(String.format("Submitted %d lineage events for dataset %s", events.size(), dataset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeCommitDataset(Collection<TaskState> taskStates, DataPublisher publisher) {
        Object object = GLOBAL_LOCK;
        synchronized (object) {
            this.commitDataset(taskStates, publisher);
        }
    }

    private void commitDataset(Collection<TaskState> taskStates, DataPublisher publisher) {
        try {
            publisher.publish(taskStates);
        }
        catch (Throwable t) {
            log.error("Failed to commit dataset", t);
            SafeDatasetCommit.setTaskFailureException(taskStates, t);
        }
    }

    private ListMultimap<TaskFactoryWrapper, TaskState> groupByTaskFactory(JobState.DatasetState datasetState) {
        ArrayListMultimap groupsMap = ArrayListMultimap.create();
        for (TaskState taskState : datasetState.getTaskStates()) {
            groupsMap.put((Object)new TaskFactoryWrapper((TaskFactory)TaskUtils.getTaskFactory((State)taskState).orNull()), (Object)taskState);
        }
        return groupsMap;
    }

    private synchronized void buildAndExecuteCommitSequence(CommitSequence.Builder builder, JobState.DatasetState datasetState, String datasetUrn) throws IOException {
        CommitSequence commitSequence = builder.addStep((CommitStep)SafeDatasetCommit.buildDatasetStateCommitStep(datasetUrn, datasetState).get()).build();
        ((CommitSequenceStore)this.jobContext.getCommitSequenceStore().get()).put(commitSequence.getJobName(), datasetUrn, commitSequence);
        commitSequence.execute();
        ((CommitSequenceStore)this.jobContext.getCommitSequenceStore().get()).delete(commitSequence.getJobName(), datasetUrn);
    }

    private void finalizeDatasetStateBeforeCommit(JobState.DatasetState datasetState) {
        for (TaskState taskState : datasetState.getTaskStates()) {
            if (taskState.getWorkingState() == WorkUnitState.WorkingState.SUCCESSFUL || this.jobContext.getJobCommitPolicy() != JobCommitPolicy.COMMIT_ON_FULL_SUCCESS) continue;
            datasetState.setState(JobState.RunningState.FAILED);
            datasetState.incrementJobFailures();
            return;
        }
        datasetState.setState(JobState.RunningState.SUCCESSFUL);
        datasetState.setNoJobFailure();
    }

    private boolean canCommitDataset(JobState.DatasetState datasetState) {
        return this.jobContext.getJobCommitPolicy() == JobCommitPolicy.COMMIT_ON_PARTIAL_SUCCESS || this.jobContext.getJobCommitPolicy() == JobCommitPolicy.COMMIT_SUCCESSFUL_TASKS || this.jobContext.getJobCommitPolicy() == JobCommitPolicy.COMMIT_ON_FULL_SUCCESS && datasetState.getState() == JobState.RunningState.SUCCESSFUL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<CommitSequence.Builder> generateCommitSequenceBuilder(JobState.DatasetState datasetState, Collection<TaskState> taskStates) {
        try (Closer closer = Closer.create();){
            Class<?> dataPublisherClass = Class.forName(datasetState.getProp("data.publisher.type", "org.apache.gobblin.publisher.BaseDataPublisher"));
            CommitSequencePublisher publisher = (CommitSequencePublisher)closer.register((Closeable)DataPublisher.getInstance(dataPublisherClass, (State)this.jobContext.getJobState()));
            publisher.publish(taskStates);
            Optional optional = publisher.getCommitSequenceBuilder();
            return optional;
        }
        catch (Throwable t) {
            log.error("Failed to generate commit sequence", t);
            SafeDatasetCommit.setTaskFailureException(datasetState.getTaskStates(), t);
            throw Throwables.propagate((Throwable)t);
        }
    }

    void checkForUnpublishedWUHandling(String datasetUrn, JobState.DatasetState datasetState, Class<? extends DataPublisher> dataPublisherClass, Closer closer) throws ReflectiveOperationException, IOException {
        if (UnpublishedHandling.class.isAssignableFrom(dataPublisherClass)) {
            DataPublisher publisher = (DataPublisher)closer.register((Closeable)DataPublisher.getInstance(dataPublisherClass, (State)this.jobContext.getJobState()));
            log.info(String.format("Calling publisher to handle unpublished work units for dataset %s of job %s.", datasetUrn, this.jobContext.getJobId()));
            ((UnpublishedHandling)publisher).handleUnpublishedWorkUnits(datasetState.getTaskStatesAsWorkUnitStates());
        }
    }

    private void finalizeDatasetState(JobState.DatasetState datasetState, String datasetUrn) {
        for (TaskState taskState : datasetState.getTaskStates()) {
            if (taskState.getWorkingState() == WorkUnitState.WorkingState.COMMITTED) continue;
            taskState.backoffActualHighWatermark();
            if (this.jobContext.getJobCommitPolicy() != JobCommitPolicy.COMMIT_ON_FULL_SUCCESS) continue;
            datasetState.setState(JobState.RunningState.FAILED);
            Optional<String> taskStateException = taskState.getTaskFailureException();
            log.warn("At least one task did not committed successfully. Setting dataset state to FAILED.", taskStateException.isPresent() ? taskStateException.get() : "Exception not set.");
        }
        datasetState.setId(datasetUrn);
    }

    private void persistDatasetState(String datasetUrn, JobState.DatasetState datasetState) throws IOException {
        log.info("Persisting dataset state for dataset " + datasetUrn);
        this.jobContext.getDatasetStateStore().persistDatasetState(datasetUrn, (State)datasetState);
    }

    public static void setTaskFailureException(Collection<? extends WorkUnitState> taskStates, Throwable t) {
        for (WorkUnitState workUnitState : taskStates) {
            ((TaskState)workUnitState).setTaskFailureException(t);
        }
    }

    private static Optional<CommitStep> buildDatasetStateCommitStep(String datasetUrn, JobState.DatasetState datasetState) {
        log.info("Creating " + DatasetStateCommitStep.class.getSimpleName() + " for dataset " + datasetUrn);
        return Optional.of((Object)((DatasetStateCommitStep.Builder)((Object)((DatasetStateCommitStep.Builder)((Object)((DatasetStateCommitStep.Builder)new DatasetStateCommitStep.Builder().withProps((State)datasetState)).withDatasetUrn(datasetUrn))).withDatasetState(datasetState))).build());
    }

    private static Map<String, Collection<TaskState>> aggregateByLineageEvent(Collection<TaskState> states) {
        HashMap statesByEvents = Maps.newHashMap();
        for (TaskState state : states) {
            String eventName = LineageInfo.getFullEventName((State)state);
            Collection statesForEvent = statesByEvents.computeIfAbsent(eventName, k -> Lists.newArrayList());
            statesForEvent.add(state);
        }
        return statesByEvents;
    }

    @ConstructorProperties(value={"shouldCommitDataInJob", "isJobCancelled", "deliverySemantics", "datasetUrn", "datasetState", "isMultithreaded", "jobContext"})
    public SafeDatasetCommit(boolean shouldCommitDataInJob, boolean isJobCancelled, DeliverySemantics deliverySemantics, String datasetUrn, JobState.DatasetState datasetState, boolean isMultithreaded, JobContext jobContext) {
        this.shouldCommitDataInJob = shouldCommitDataInJob;
        this.isJobCancelled = isJobCancelled;
        this.deliverySemantics = deliverySemantics;
        this.datasetUrn = datasetUrn;
        this.datasetState = datasetState;
        this.isMultithreaded = isMultithreaded;
        this.jobContext = jobContext;
    }

    private static class TaskFactoryWrapper {
        private final TaskFactory taskFactory;

        public boolean equals(Object other) {
            if (!(other instanceof TaskFactoryWrapper)) {
                return false;
            }
            if (this.taskFactory == null) {
                return ((TaskFactoryWrapper)other).taskFactory == null;
            }
            return ((TaskFactoryWrapper)other).taskFactory != null && this.taskFactory.getClass().equals(((TaskFactoryWrapper)other).taskFactory.getClass());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> klazz = this.taskFactory == null ? null : this.taskFactory.getClass();
            result = result * 59 + (klazz == null ? 43 : klazz.hashCode());
            return result;
        }

        @ConstructorProperties(value={"taskFactory"})
        public TaskFactoryWrapper(TaskFactory taskFactory) {
            this.taskFactory = taskFactory;
        }

        public TaskFactory getTaskFactory() {
            return this.taskFactory;
        }

        public String toString() {
            return "SafeDatasetCommit.TaskFactoryWrapper(taskFactory=" + this.getTaskFactory() + ")";
        }
    }
}

