/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.runtime.CheckpointableWatermarkState;
import org.apache.gobblin.runtime.StateStoreBasedWatermarkStorage;
import org.apache.gobblin.runtime.TaskState;
import org.apache.gobblin.runtime.cli.CliApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="watermarks", description="Inspect streaming watermarks")
public class StateStoreBasedWatermarkStorageCli
implements CliApplication {
    private static final Logger log = LoggerFactory.getLogger(StateStoreBasedWatermarkStorageCli.class);
    private static final Option HELP = Option.builder((String)"h").longOpt("help").build();
    private static final Option ZK = Option.builder((String)"z").longOpt("zk").desc("Zk connect string").hasArg().build();
    private static final Option JOB_NAME = Option.builder((String)"j").longOpt("jobName").desc("The Job name").hasArg().build();
    private static final Option ROOT_DIR = Option.builder((String)"r").longOpt("rootDir").desc("The State Store Root Directory").hasArg().build();
    private static final Option WATCH = Option.builder((String)"w").longOpt("watch").desc("Watch the watermarks").build();

    public void run(String[] args) {
        CommandLine cli;
        Options options = new Options();
        options.addOption(HELP);
        options.addOption(ZK);
        options.addOption(JOB_NAME);
        options.addOption(ROOT_DIR);
        options.addOption(WATCH);
        try {
            DefaultParser parser = new DefaultParser();
            cli = parser.parse(options, Arrays.copyOfRange(args, 1, args.length));
        }
        catch (ParseException pe) {
            System.out.println("Command line parse exception: " + pe.getMessage());
            return;
        }
        if (cli.hasOption(HELP.getOpt())) {
            this.printUsage(options);
            return;
        }
        TaskState taskState = new TaskState();
        if (!cli.hasOption(JOB_NAME.getOpt())) {
            log.error("Need Job Name to be specified --", (Object)JOB_NAME.getLongOpt());
            throw new RuntimeException("Need Job Name to be specified");
        }
        String jobName = cli.getOptionValue(JOB_NAME.getOpt());
        log.info("Using job name: {}", (Object)jobName);
        taskState.setProp("job.name", jobName);
        String zkAddress = "locahost:2181";
        if (cli.hasOption(ZK.getOpt())) {
            zkAddress = cli.getOptionValue(ZK.getOpt());
        }
        log.info("Using zk address : {}", (Object)zkAddress);
        taskState.setProp("streaming.watermarkStateStore.type", "zk");
        taskState.setProp("state.store.zk.connectString", zkAddress);
        if (!cli.hasOption(ROOT_DIR.getOpt())) {
            log.error("Need root directory specified");
            this.printUsage(options);
            return;
        }
        String rootDir = cli.getOptionValue(ROOT_DIR.getOpt());
        taskState.setProp("streaming.watermarkStateStore.config.state.store.dir", rootDir);
        log.info("Setting root dir to {}", (Object)rootDir);
        StateStoreBasedWatermarkStorage stateStoreBasedWatermarkStorage = new StateStoreBasedWatermarkStorage((State)taskState);
        final AtomicBoolean stop = new AtomicBoolean(true);
        if (cli.hasOption(WATCH.getOpt())) {
            stop.set(false);
        }
        try {
            if (!stop.get()) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        stop.set(true);
                    }
                });
            }
            do {
                boolean foundWatermark = false;
                try {
                    for (CheckpointableWatermarkState wmState : stateStoreBasedWatermarkStorage.getAllCommittedWatermarks()) {
                        foundWatermark = true;
                        System.out.println(wmState.getProperties());
                    }
                }
                catch (IOException ie) {
                    Throwables.propagate((Throwable)ie);
                }
                if (!foundWatermark) {
                    System.out.println("No watermarks found.");
                }
                if (stop.get()) continue;
                Thread.sleep(1000L);
            } while (!stop.get());
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private void printUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator((Comparator)new Comparator<Option>(){

            @Override
            public int compare(Option o1, Option o2) {
                if (o1.isRequired() && !o2.isRequired()) {
                    return -1;
                }
                if (!o1.isRequired() && o2.isRequired()) {
                    return 1;
                }
                return o1.getOpt().compareTo(o2.getOpt());
            }
        });
        String usage = "gobblin watermarks ";
        formatter.printHelp(usage, options);
    }
}

