/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metastore.DatasetStateStore;
import org.apache.gobblin.runtime.cli.CliApplication;
import org.apache.gobblin.runtime.cli.CliObjectSupport;
import org.apache.gobblin.runtime.cli.ConstructorAndPublicMethodsCliObjectFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="stateMigration", description="Command line tools for migrating state store")
public class StateStoreMigrationCli
implements CliApplication {
    private static final Logger log = LoggerFactory.getLogger(StateStoreMigrationCli.class);
    private static final String SOURCE_KEY = "source";
    private static final String DESTINATION_KEY = "destination";
    private static final String JOB_NAME_KEY = "jobName";

    private String extractStoreName(String dirPath) {
        return dirPath.substring(dirPath.lastIndexOf(47) + 1);
    }

    public void run(String[] args) throws Exception {
        ConstructorAndPublicMethodsCliObjectFactory factory = new ConstructorAndPublicMethodsCliObjectFactory(Command.class);
        Command command = (Command)factory.buildObject(args, 1, true, args[0]);
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        FSDataInputStream inputStream = fs.open(command.path);
        Config config = ConfigFactory.parseReader((Reader)new InputStreamReader((InputStream)inputStream, Charset.defaultCharset()));
        String storeName = this.extractStoreName(config.getConfig(SOURCE_KEY).getString("state.store.dir"));
        Preconditions.checkNotNull((Object)config.getObject(SOURCE_KEY));
        Preconditions.checkNotNull((Object)config.getObject(DESTINATION_KEY));
        Preconditions.checkNotNull((Object)config.getString(JOB_NAME_KEY));
        DatasetStateStore dstDatasetStateStore = DatasetStateStore.buildDatasetStateStore((Config)config.getConfig(DESTINATION_KEY));
        DatasetStateStore srcDatasetStateStore = DatasetStateStore.buildDatasetStateStore((Config)config.getConfig(SOURCE_KEY));
        Map map = srcDatasetStateStore.getLatestDatasetStatesByUrns(config.getString(JOB_NAME_KEY));
        for (Map.Entry entry : map.entrySet()) {
            dstDatasetStateStore.persistDatasetState((String)entry.getKey(), (State)entry.getValue());
        }
        if (command.deleteSourceStateStore) {
            try {
                srcDatasetStateStore.delete(storeName);
            }
            catch (IOException ioe) {
                log.warn("The source state store has been deleted.", (Throwable)ioe);
            }
        }
    }

    public static class Command {
        private final Path path;
        private boolean deleteSourceStateStore = false;

        @CliObjectSupport(argumentNames={"configPath"})
        public Command(String path) throws URISyntaxException, IOException {
            this.path = new Path(path);
        }

        public void deleteSourceStateStore() {
            this.deleteSourceStateStore = true;
        }
    }
}

