/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.google.common.eventbus.EventBus;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.AbstractScheduledService;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metastore.StateStore;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.NewTaskCompletionEvent;
import org.apache.gobblin.runtime.SafeDatasetCommit;
import org.apache.gobblin.runtime.TaskState;
import org.apache.gobblin.runtime.TaskStateCollectorServiceHandler;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ParallelRunner;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStateCollectorService
extends AbstractScheduledService {
    private static final Logger log = LoggerFactory.getLogger(TaskStateCollectorService.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskStateCollectorService.class);
    private final JobState jobState;
    private final EventBus eventBus;
    private final int stateSerDeRunnerThreads;
    private final int outputTaskStatesCollectorIntervalSeconds;
    private final StateStore<TaskState> taskStateStore;
    private final Path outputTaskStateDir;
    private final Optional<TaskStateCollectorServiceHandler> optionalTaskCollectorHandler;
    private final Closer handlerCloser = Closer.create();
    private boolean isJobProceedOnCollectorServiceFailure;
    private static final boolean defaultPolicyOnCollectorServiceFailure = true;

    public TaskStateCollectorService(Properties jobProps, JobState jobState, EventBus eventBus, StateStore<TaskState> taskStateStore, Path outputTaskStateDir) {
        this.jobState = jobState;
        this.eventBus = eventBus;
        this.taskStateStore = taskStateStore;
        this.outputTaskStateDir = outputTaskStateDir;
        this.stateSerDeRunnerThreads = Integer.parseInt(jobProps.getProperty("parallel.runner.threads", Integer.toString(10)));
        this.outputTaskStatesCollectorIntervalSeconds = Integer.parseInt(jobProps.getProperty("task.state.collector.interval.secs", Integer.toString(60)));
        if (!StringUtils.isBlank((CharSequence)jobProps.getProperty("task.state.collector.handler.class"))) {
            String handlerTypeName = jobProps.getProperty("task.state.collector.handler.class");
            try {
                ClassAliasResolver aliasResolver = new ClassAliasResolver(TaskStateCollectorServiceHandler.TaskStateCollectorServiceHandlerFactory.class);
                TaskStateCollectorServiceHandler.TaskStateCollectorServiceHandlerFactory handlerFactory = (TaskStateCollectorServiceHandler.TaskStateCollectorServiceHandlerFactory)aliasResolver.resolveClass(handlerTypeName).newInstance();
                this.optionalTaskCollectorHandler = Optional.of((Object)this.handlerCloser.register((Closeable)handlerFactory.createHandler(this.jobState)));
            }
            catch (ReflectiveOperationException rfe) {
                throw new RuntimeException("Could not construct TaskCollectorHandler " + handlerTypeName, rfe);
            }
        } else {
            this.optionalTaskCollectorHandler = Optional.absent();
        }
        this.isJobProceedOnCollectorServiceFailure = jobState.getPropAsBoolean("job.proceed.onTaskStateCollectorServiceFailure", true);
    }

    protected void runOneIteration() throws Exception {
        this.collectOutputTaskStates();
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedRateSchedule((long)this.outputTaskStatesCollectorIntervalSeconds, (long)this.outputTaskStatesCollectorIntervalSeconds, (TimeUnit)TimeUnit.SECONDS);
    }

    protected void startUp() throws Exception {
        LOGGER.info("Starting the " + TaskStateCollectorService.class.getSimpleName());
        super.startUp();
    }

    protected void shutDown() throws Exception {
        LOGGER.info("Stopping the " + TaskStateCollectorService.class.getSimpleName());
        try {
            this.runOneIteration();
        }
        finally {
            super.shutDown();
            this.handlerCloser.close();
        }
    }

    private void collectOutputTaskStates() throws IOException {
        List taskStateNames = this.taskStateStore.getTableNames(this.outputTaskStateDir.getName(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input.endsWith(".tst") && !input.startsWith("_tmp_");
            }
        });
        if (taskStateNames == null || taskStateNames.size() == 0) {
            LOGGER.debug("No output task state files found in " + this.outputTaskStateDir);
            return;
        }
        final ConcurrentLinkedQueue taskStateQueue = Queues.newConcurrentLinkedQueue();
        try (ParallelRunner stateSerDeRunner = new ParallelRunner(this.stateSerDeRunnerThreads, null);){
            for (final String taskStateName : taskStateNames) {
                LOGGER.debug("Found output task state file " + taskStateName);
                stateSerDeRunner.submitCallable((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        TaskState taskState = (TaskState)((Object)TaskStateCollectorService.this.taskStateStore.getAll(TaskStateCollectorService.this.outputTaskStateDir.getName(), taskStateName).get(0));
                        taskStateQueue.add(taskState);
                        TaskStateCollectorService.this.taskStateStore.delete(TaskStateCollectorService.this.outputTaskStateDir.getName(), taskStateName);
                        return null;
                    }
                }, "Deserialize state for " + taskStateName);
            }
        }
        catch (IOException ioe) {
            LOGGER.warn("Could not read all task state files.");
        }
        LOGGER.info(String.format("Collected task state of %d completed tasks", taskStateQueue.size()));
        for (TaskState taskState : taskStateQueue) {
            taskState.setJobState((State)this.jobState);
            this.jobState.addTaskState(taskState);
        }
        if (this.optionalTaskCollectorHandler.isPresent()) {
            LOGGER.info("Execute Pipelined TaskStateCollectorService Handler for " + taskStateQueue.size() + " tasks");
            try {
                ((TaskStateCollectorServiceHandler)this.optionalTaskCollectorHandler.get()).handle(taskStateQueue);
            }
            catch (Throwable t) {
                if (this.isJobProceedOnCollectorServiceFailure) {
                    log.error("Failed to commit dataset while job proceeds", t);
                    SafeDatasetCommit.setTaskFailureException(taskStateQueue, t);
                }
                throw new RuntimeException("Hive Registration as the TaskStateCollectorServiceHandler failed.", t);
            }
        }
        this.eventBus.post((Object)new NewTaskCompletionEvent((Collection<TaskState>)ImmutableList.copyOf((Collection)taskStateQueue)));
    }

    public Optional<TaskStateCollectorServiceHandler> getOptionalTaskCollectorHandler() {
        return this.optionalTaskCollectorHandler;
    }
}

