/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.api.JobExecution;
import org.apache.gobblin.runtime.api.JobExecutionStateListener;
import org.apache.gobblin.runtime.api.JobExecutionStatus;
import org.apache.gobblin.runtime.api.JobSpec;

@Alpha
public class JobExecutionState
implements JobExecutionStatus {
    public static final String UKNOWN_STAGE = "unkown";
    private static final Map<JobState.RunningState, Set<JobState.RunningState>> EXPECTED_PRE_TRANSITION_STATES = ImmutableMap.builder().put((Object)JobState.RunningState.PENDING, (Object)ImmutableSet.builder().build()).put((Object)JobState.RunningState.RUNNING, (Object)ImmutableSet.builder().add((Object)JobState.RunningState.PENDING).build()).put((Object)JobState.RunningState.SUCCESSFUL, (Object)ImmutableSet.builder().add((Object)JobState.RunningState.RUNNING).build()).put((Object)JobState.RunningState.COMMITTED, (Object)ImmutableSet.builder().add((Object)JobState.RunningState.SUCCESSFUL).build()).put((Object)JobState.RunningState.FAILED, (Object)ImmutableSet.builder().add((Object)JobState.RunningState.PENDING).add((Object)JobState.RunningState.RUNNING).add((Object)JobState.RunningState.SUCCESSFUL).build()).put((Object)JobState.RunningState.CANCELLED, (Object)ImmutableSet.builder().add((Object)JobState.RunningState.PENDING).add((Object)JobState.RunningState.RUNNING).add((Object)JobState.RunningState.SUCCESSFUL).build()).build();
    public static final Predicate<JobExecutionState> EXECUTION_DONE_PREDICATE = new Predicate<JobExecutionState>(){

        public boolean apply(@Nonnull JobExecutionState state) {
            return null != state.getRunningState() && state.getRunningState().isDone();
        }

        public String toString() {
            return "runningState().isDone()";
        }
    };
    private final JobExecution jobExecution;
    private final Optional<JobExecutionStateListener> listener;
    final JobSpec jobSpec;
    private final Lock changeLock = new ReentrantLock();
    private final Condition runningStateChanged = this.changeLock.newCondition();
    private JobState.RunningState runningState;
    private String stage;
    private Map<String, Object> executionMetadata;

    public JobExecutionState(JobSpec jobSpec, JobExecution jobExecution, Optional<JobExecutionStateListener> listener) {
        this.jobExecution = jobExecution;
        this.runningState = null;
        this.stage = UKNOWN_STAGE;
        this.jobSpec = jobSpec;
        this.listener = listener;
        this.executionMetadata = new HashMap<String, Object>();
    }

    public Map<String, Object> getExecutionMetadata() {
        this.changeLock.lock();
        try {
            Map<String, Object> map = Collections.unmodifiableMap(this.executionMetadata);
            return map;
        }
        finally {
            this.changeLock.unlock();
        }
    }

    public String toString() {
        this.changeLock.lock();
        try {
            String string = Objects.toStringHelper((String)JobExecutionState.class.getSimpleName()).add("jobExecution", (Object)this.jobExecution).add("runningState", (Object)this.runningState).add("stage", (Object)this.stage).toString();
            return string;
        }
        finally {
            this.changeLock.unlock();
        }
    }

    @Override
    public JobState.RunningState getRunningState() {
        this.changeLock.lock();
        try {
            JobState.RunningState runningState = this.runningState;
            return runningState;
        }
        finally {
            this.changeLock.unlock();
        }
    }

    @Override
    public String getStage() {
        this.changeLock.lock();
        try {
            String string = this.stage;
            return string;
        }
        finally {
            this.changeLock.unlock();
        }
    }

    public void setRunningState(JobState.RunningState runningState) {
        this.doRunningStateChange(runningState);
    }

    public void switchToPending() {
        this.doRunningStateChange(JobState.RunningState.PENDING);
    }

    public void switchToRunning() {
        this.doRunningStateChange(JobState.RunningState.RUNNING);
    }

    public void switchToSuccessful() {
        this.doRunningStateChange(JobState.RunningState.SUCCESSFUL);
    }

    public void switchToFailed() {
        this.doRunningStateChange(JobState.RunningState.FAILED);
    }

    public void switchToCommitted() {
        this.doRunningStateChange(JobState.RunningState.COMMITTED);
    }

    public void switchToCancelled() {
        this.doRunningStateChange(JobState.RunningState.CANCELLED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRunningStateChange(JobState.RunningState newState) {
        JobState.RunningState oldState = null;
        JobExecutionStateListener stateListener = null;
        this.changeLock.lock();
        try {
            if (null == this.runningState) {
                Preconditions.checkState((JobState.RunningState.PENDING == newState ? 1 : 0) != 0);
            } else {
                Preconditions.checkState((boolean)EXPECTED_PRE_TRANSITION_STATES.get((Object)newState).contains((Object)this.runningState), (Object)("unexpected state transition " + (Object)((Object)this.runningState) + " --> " + (Object)((Object)newState)));
            }
            oldState = this.runningState;
            this.runningState = newState;
            if (this.listener.isPresent()) {
                stateListener = (JobExecutionStateListener)this.listener.get();
            }
            this.runningStateChanged.signalAll();
        }
        finally {
            this.changeLock.unlock();
        }
        if (null != stateListener) {
            stateListener.onStatusChange(this, oldState, newState);
        }
    }

    public void setStage(String newStage) {
        this.changeLock.lock();
        try {
            String oldStage = this.stage;
            this.stage = newStage;
            if (this.listener.isPresent()) {
                ((JobExecutionStateListener)this.listener.get()).onStageTransition(this, oldStage, this.stage);
            }
        }
        finally {
            this.changeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMedatata(String key, Object value) {
        this.changeLock.lock();
        try {
            Object oldValue = this.executionMetadata.get(key);
            this.executionMetadata.put(key, value);
            if (this.listener.isPresent()) {
                ((JobExecutionStateListener)this.listener.get()).onMetadataChange(this, key, oldValue, value);
            }
        }
        finally {
            this.changeLock.unlock();
        }
    }

    public void awaitForDone(long timeoutMs) throws InterruptedException, TimeoutException {
        this.awaitForStatePredicate(EXECUTION_DONE_PREDICATE, timeoutMs);
    }

    public void awaitForState(final JobState.RunningState targetState, long timeoutMs) throws InterruptedException, TimeoutException {
        this.awaitForStatePredicate(new Predicate<JobExecutionState>(){

            public boolean apply(JobExecutionState state) {
                return null != state.getRunningState() && state.getRunningState().equals((Object)targetState);
            }

            public String toString() {
                return "runningState == " + (Object)((Object)targetState);
            }
        }, timeoutMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitForStatePredicate(Predicate<JobExecutionState> predicate, long timeoutMs) throws InterruptedException, TimeoutException {
        Preconditions.checkArgument((timeoutMs >= 0L ? 1 : 0) != 0);
        if (0L == timeoutMs) {
            timeoutMs = Long.MAX_VALUE;
        }
        long startTimeMs = System.currentTimeMillis();
        long millisRemaining = timeoutMs;
        this.changeLock.lock();
        try {
            while (!predicate.apply((Object)this) && millisRemaining > 0L && this.runningStateChanged.await(millisRemaining, TimeUnit.MILLISECONDS)) {
                millisRemaining = timeoutMs - (System.currentTimeMillis() - startTimeMs);
            }
            if (!predicate.apply((Object)this)) {
                throw new TimeoutException("Timeout waiting for state predicate: " + predicate);
            }
        }
        finally {
            this.changeLock.unlock();
        }
    }

    @Override
    public JobExecution getJobExecution() {
        return this.jobExecution;
    }

    public JobSpec getJobSpec() {
        return this.jobSpec;
    }
}

