/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.api;

import com.google.common.base.Objects;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.api.JobExecutionState;
import org.apache.gobblin.util.callbacks.Callback;

public interface JobExecutionStateListener {
    public void onStatusChange(JobExecutionState var1, JobState.RunningState var2, JobState.RunningState var3);

    public void onStageTransition(JobExecutionState var1, String var2, String var3);

    public void onMetadataChange(JobExecutionState var1, String var2, Object var3, Object var4);

    public static class MetadataChangeCallback
    extends Callback<JobExecutionStateListener, Void> {
        private final JobExecutionState state;
        private final String key;
        private final Object oldValue;
        private final Object newValue;

        public MetadataChangeCallback(JobExecutionState state, String key, Object oldValue, Object newValue) {
            super(Objects.toStringHelper((String)"onMetadataChange").add("state", (Object)state).add("key", (Object)key).add("oldValue", oldValue).add("newValue", newValue).toString());
            this.state = state;
            this.key = key;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public Void apply(JobExecutionStateListener input) {
            input.onMetadataChange(this.state, this.key, this.oldValue, this.newValue);
            return null;
        }
    }

    public static class StageTransitionCallback
    extends Callback<JobExecutionStateListener, Void> {
        private final JobExecutionState state;
        private final String previousStage;
        private final String newStage;

        public StageTransitionCallback(JobExecutionState state, String previousStage, String newStage) {
            super(Objects.toStringHelper((String)"onStageTransition").add("state", (Object)state).add("previousStage", (Object)previousStage).add("newStage", (Object)newStage).toString());
            this.state = state;
            this.previousStage = previousStage;
            this.newStage = newStage;
        }

        public Void apply(JobExecutionStateListener input) {
            input.onStageTransition(this.state, this.previousStage, this.newStage);
            return null;
        }
    }

    public static class StatusChangeCallback
    extends Callback<JobExecutionStateListener, Void> {
        private final JobExecutionState state;
        private final JobState.RunningState previousStatus;
        private final JobState.RunningState newStatus;

        public StatusChangeCallback(JobExecutionState state, JobState.RunningState previousStatus, JobState.RunningState newStatus) {
            super(Objects.toStringHelper((String)"onStatusChange").add("state", (Object)state).add("previousStatus", (Object)previousStatus).add("newStatus", (Object)newStatus).toString());
            this.state = state;
            this.previousStatus = previousStatus;
            this.newStatus = newStatus;
        }

        public Void apply(JobExecutionStateListener input) {
            input.onStatusChange(this.state, this.previousStatus, this.newStatus);
            return null;
        }
    }
}

