/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.crypto;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.crypto.EncryptionFactory;
import org.apache.gobblin.runtime.cli.CliApplication;

@Alias(value="decrypt", description="Decryption utilities")
public class DecryptCli
implements CliApplication {
    private static final Option KEYSTORE_LOCATION = Option.builder((String)"k").longOpt("ks_location").hasArg().required().desc("Keystore location").build();
    private static final Option INPUT_LOCATION = Option.builder((String)"i").longOpt("in").hasArg().required().desc("File to be decrypted").build();
    private static final Option OUTPUT_LOCATION = Option.builder((String)"o").longOpt("out").hasArg().required().desc("Output file (stdin if not specified)").build();

    public void run(String[] args) {
        try {
            CommandLine cli;
            Options options = new Options();
            options.addOption(KEYSTORE_LOCATION);
            options.addOption(INPUT_LOCATION);
            options.addOption(OUTPUT_LOCATION);
            try {
                DefaultParser parser = new DefaultParser();
                cli = parser.parse(options, Arrays.copyOfRange(args, 1, args.length));
            }
            catch (ParseException pe) {
                System.out.println("Command line parse exception: " + pe.getMessage());
                this.printUsage(options);
                return;
            }
            ImmutableMap encryptionProperties = ImmutableMap.of((Object)"algorithm", (Object)"aes_rotating", (Object)"keystore_path", (Object)cli.getOptionValue(KEYSTORE_LOCATION.getOpt()), (Object)"keystore_password", (Object)DecryptCli.getPasswordFromConsole());
            BufferedInputStream fIs = new BufferedInputStream(new FileInputStream(new File(cli.getOptionValue(INPUT_LOCATION.getOpt()))));
            InputStream cipherStream = EncryptionFactory.buildStreamCryptoProvider((Map)encryptionProperties).decodeInputStream((InputStream)fIs);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(cli.getOptionValue(OUTPUT_LOCATION.getOpt())));
            long bytes = IOUtils.copyLarge((InputStream)cipherStream, (OutputStream)out);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            System.out.println("Copied " + String.valueOf(bytes) + " bytes.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void printUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String usage = "decryption utilities ";
        formatter.printHelp(usage, options);
    }

    private static String getPasswordFromConsole() {
        System.out.print("Please enter the keystore password: ");
        return new String(System.console().readPassword());
    }
}

