/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.job_catalog;

import com.typesafe.config.Config;
import java.io.IOException;
import java.net.URI;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.job_catalog.ImmutableFSJobCatalog;
import org.apache.gobblin.runtime.job_catalog.JobCatalogListenersList;
import org.apache.gobblin.util.PullFileLoader;
import org.apache.gobblin.util.filesystem.PathAlterationListenerAdaptor;
import org.apache.hadoop.fs.Path;

public class FSPathAlterationListenerAdaptor
extends PathAlterationListenerAdaptor {
    private final Path jobConfDirPath;
    private final PullFileLoader loader;
    private final Config sysConfig;
    private final JobCatalogListenersList listeners;
    private final ImmutableFSJobCatalog.JobSpecConverter converter;

    FSPathAlterationListenerAdaptor(Path jobConfDirPath, PullFileLoader loader, Config sysConfig, JobCatalogListenersList listeners, ImmutableFSJobCatalog.JobSpecConverter converter) {
        this.jobConfDirPath = jobConfDirPath;
        this.loader = loader;
        this.sysConfig = sysConfig;
        this.listeners = listeners;
        this.converter = converter;
    }

    public void onFileCreate(Path rawPath) {
        try {
            JobSpec newJobSpec = this.converter.apply(this.loader.loadPullFile(rawPath, this.sysConfig, false));
            this.listeners.onAddJob(newJobSpec);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void onFileDelete(Path rawPath) {
        URI jobSpecUri = this.converter.computeURI(rawPath);
        this.listeners.onDeleteJob(jobSpecUri, null);
    }

    public void onFileChange(Path rawPath) {
        try {
            JobSpec updatedJobSpec = this.converter.apply(this.loader.loadPullFile(rawPath, this.sysConfig, false));
            this.listeners.onUpdateJob(updatedJobSpec);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

