/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.kafka;

import com.codahale.metrics.Counter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AbstractIdleService;
import com.typesafe.config.Config;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kafka.consumer.Consumer;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.KafkaStream;
import kafka.javaapi.consumer.ConsumerConnector;
import kafka.message.MessageAndMetadata;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.ExecutorsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HighLevelConsumer<K, V>
extends AbstractIdleService {
    private static final Logger log = LoggerFactory.getLogger(HighLevelConsumer.class);
    public static final String GROUP_ID_KEY = "group.id";
    private static final String DEFAULT_GROUP_ID = "KafkaJobSpecMonitor";
    private final String topic;
    private final int numThreads;
    private final Config config;
    private final ConsumerConfig consumerConfig;
    private MetricContext metricContext;
    private Counter messagesRead;
    private ConsumerConnector consumer;
    private ExecutorService executor;

    public HighLevelConsumer(String topic, Config config, int numThreads) {
        this.topic = topic;
        this.numThreads = numThreads;
        this.config = config;
        this.consumerConfig = this.createConsumerConfig(config);
    }

    @VisibleForTesting
    protected void buildMetricsContextAndMetrics() {
        this.metricContext = Instrumented.getMetricContext((State)new State(ConfigUtils.configToProperties((Config)this.config)), ((Object)((Object)this)).getClass(), this.getTagsForMetrics());
        this.createMetrics();
    }

    @VisibleForTesting
    protected void shutdownMetrics() throws IOException {
        if (this.metricContext != null) {
            this.metricContext.close();
        }
    }

    protected void createMetrics() {
        this.messagesRead = this.metricContext.counter("gobblin.kafka.highLevelConsumer.messagesRead");
    }

    protected List<Tag<?>> getTagsForMetrics() {
        ArrayList tags = Lists.newArrayList();
        tags.add(new Tag("topic", (Object)this.topic));
        tags.add(new Tag("groupId", (Object)this.consumerConfig.groupId()));
        return tags;
    }

    protected abstract void processMessage(MessageAndMetadata<K, V> var1);

    protected void startUp() {
        this.buildMetricsContextAndMetrics();
        this.consumer = this.createConsumerConnector();
        List<KafkaStream<byte[], byte[]>> streams = this.createStreams();
        this.executor = Executors.newFixedThreadPool(this.numThreads);
        int threadNumber = 0;
        for (KafkaStream<byte[], byte[]> stream : streams) {
            this.executor.execute(new MonitorConsumer(stream));
            ++threadNumber;
        }
    }

    protected ConsumerConfig createConsumerConfig(Config config) {
        Properties props = ConfigUtils.configToProperties((Config)config);
        if (!props.containsKey(GROUP_ID_KEY)) {
            props.setProperty(GROUP_ID_KEY, DEFAULT_GROUP_ID);
        }
        return new ConsumerConfig(props);
    }

    protected ConsumerConnector createConsumerConnector() {
        return Consumer.createJavaConsumerConnector((ConsumerConfig)this.consumerConfig);
    }

    protected List<KafkaStream<byte[], byte[]>> createStreams() {
        HashMap topicCountMap = Maps.newHashMap();
        topicCountMap.put(this.topic, this.numThreads);
        Map consumerMap = this.consumer.createMessageStreams((Map)topicCountMap);
        return (List)consumerMap.get(this.topic);
    }

    public void shutDown() {
        if (this.consumer != null) {
            this.consumer.shutdown();
        }
        if (this.executor != null) {
            ExecutorsUtils.shutdownExecutorService((ExecutorService)this.executor, (Optional)Optional.of((Object)log), (long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        try {
            this.shutdownMetrics();
        }
        catch (IOException ioe) {
            log.warn("Failed to shutdown metrics for " + ((Object)((Object)this)).getClass().getSimpleName());
        }
    }

    public String getTopic() {
        return this.topic;
    }

    public MetricContext getMetricContext() {
        return this.metricContext;
    }

    public class MonitorConsumer
    implements Runnable {
        private final KafkaStream stream;

        @Override
        public void run() {
            for (MessageAndMetadata message : this.stream) {
                HighLevelConsumer.this.messagesRead.inc();
                HighLevelConsumer.this.processMessage(message);
            }
        }

        @ConstructorProperties(value={"stream"})
        public MonitorConsumer(KafkaStream stream) {
            this.stream = stream;
        }
    }
}

