/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.listeners;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import org.apache.gobblin.runtime.JobContext;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.listeners.AbstractJobListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunOnceJobListener
extends AbstractJobListener {
    private static final Logger LOG = LoggerFactory.getLogger(RunOnceJobListener.class);

    @Override
    public void onJobCompletion(JobContext jobContext) {
        JobState jobState = jobContext.getJobState();
        if (!jobState.contains("job.config.path")) {
            LOG.error("Job configuration file path not found in job state of job " + jobState.getJobId());
            return;
        }
        String jobConfigFile = jobState.getProp("job.config.path");
        try {
            Files.move((File)new File(jobConfigFile), (File)new File(jobConfigFile + ".done"));
        }
        catch (IOException ioe) {
            LOG.error("Failed to rename job configuration file for job " + jobState.getJobName(), (Throwable)ioe);
        }
    }
}

