/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.locks;

import com.google.common.base.Optional;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.runtime.instance.hadoop.HadoopConfigLoader;
import org.apache.gobblin.runtime.locks.AbstractJobLockFactoryManager;
import org.apache.gobblin.runtime.locks.FileBasedJobLock;
import org.apache.gobblin.runtime.locks.FileBasedJobLockFactory;
import org.slf4j.Logger;

@Alias(value="file")
public class FileBasedJobLockFactoryManager
extends AbstractJobLockFactoryManager<FileBasedJobLock, FileBasedJobLockFactory> {
    public static final String CONFIG_PREFIX = "job.lock.file";

    @Override
    protected Config getFactoryConfig(Config sysConfig) {
        return sysConfig.hasPath(CONFIG_PREFIX) ? sysConfig.getConfig(CONFIG_PREFIX) : ConfigFactory.empty();
    }

    @Override
    protected FileBasedJobLockFactory createFactoryInstance(Optional<Logger> log, Config sysConfig, Config factoryConfig) {
        HadoopConfigLoader hadoopConfLoader = new HadoopConfigLoader(sysConfig);
        try {
            return FileBasedJobLockFactory.create(factoryConfig, hadoopConfLoader.getConf(), log);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create job lock factory: " + e, e);
        }
    }
}

