/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.scheduler;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ThreadFactory;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobSpecSchedule;
import org.apache.gobblin.runtime.scheduler.AbstractJobSpecScheduler;
import org.apache.gobblin.runtime.std.DefaultJobSpecScheduleImpl;
import org.apache.gobblin.util.LoggingUncaughtExceptionHandler;
import org.slf4j.Logger;

public class ImmediateJobSpecScheduler
extends AbstractJobSpecScheduler {
    private final ThreadFactory _jobRunnablesThreadFactory = new ThreadFactoryBuilder().setDaemon(false).setNameFormat(this.getLog().getName() + "-thread-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new LoggingUncaughtExceptionHandler(Optional.of((Object)this.getLog()))).build();

    public ImmediateJobSpecScheduler(Optional<Logger> log) {
        super(log);
    }

    @Override
    protected JobSpecSchedule doScheduleJob(JobSpec jobSpec, Runnable jobRunnable) {
        Thread runThread = this._jobRunnablesThreadFactory.newThread(jobRunnable);
        this.getLog().info("Starting JobSpec " + jobSpec + " in thread " + runThread.getName());
        DefaultJobSpecScheduleImpl schedule = DefaultJobSpecScheduleImpl.createImmediateSchedule(jobSpec, jobRunnable);
        runThread.start();
        return schedule;
    }

    @Override
    protected void doUnschedule(JobSpecSchedule existingSchedule) {
    }
}

