/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.scheduler;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobSpecSchedule;
import org.apache.gobblin.runtime.api.JobSpecSchedulerListener;
import org.apache.gobblin.runtime.api.JobSpecSchedulerListenersContainer;
import org.apache.gobblin.util.callbacks.CallbacksDispatcher;
import org.slf4j.Logger;

public class JobSpecSchedulerListeners
implements JobSpecSchedulerListenersContainer,
JobSpecSchedulerListener,
Closeable {
    private CallbacksDispatcher<JobSpecSchedulerListener> _dispatcher;

    public JobSpecSchedulerListeners(Optional<ExecutorService> execService, Optional<Logger> log) {
        this._dispatcher = new CallbacksDispatcher(execService, log);
    }

    public JobSpecSchedulerListeners(Logger log) {
        this._dispatcher = new CallbacksDispatcher(log);
    }

    public JobSpecSchedulerListeners() {
        this._dispatcher = new CallbacksDispatcher();
    }

    @Override
    public void registerJobSpecSchedulerListener(JobSpecSchedulerListener listener) {
        this._dispatcher.addListener((Object)listener);
    }

    @Override
    public void unregisterJobSpecSchedulerListener(JobSpecSchedulerListener listener) {
        this._dispatcher.removeListener((Object)listener);
    }

    @Override
    public List<JobSpecSchedulerListener> getJobSpecSchedulerListeners() {
        return this._dispatcher.getListeners();
    }

    @Override
    public void onJobScheduled(JobSpecSchedule jobSchedule) {
        try {
            this._dispatcher.execCallbacks((Function)new JobSpecSchedulerListener.JobScheduledCallback(jobSchedule));
        }
        catch (InterruptedException e) {
            this._dispatcher.getLog().warn("onJobScheduled interrupted.");
        }
    }

    @Override
    public void onJobTriggered(JobSpec jobSpec) {
        try {
            this._dispatcher.execCallbacks((Function)new JobSpecSchedulerListener.JobTriggeredCallback(jobSpec));
        }
        catch (InterruptedException e) {
            this._dispatcher.getLog().warn("onJobTriggered interrupted.");
        }
    }

    @Override
    public void onJobUnscheduled(JobSpecSchedule jobSchedule) {
        try {
            this._dispatcher.execCallbacks((Function)new JobSpecSchedulerListener.JobUnscheduledCallback(jobSchedule));
        }
        catch (InterruptedException e) {
            this._dispatcher.getLog().warn("onJobUnscheduled interrupted.");
        }
    }

    @Override
    public void registerWeakJobSpecSchedulerListener(JobSpecSchedulerListener listener) {
        this._dispatcher.addWeakListener((Object)listener);
    }

    @Override
    public void close() throws IOException {
        this._dispatcher.close();
    }
}

