/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.std;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.api.JobExecutionState;
import org.apache.gobblin.runtime.api.JobExecutionStateListener;
import org.apache.gobblin.runtime.api.JobExecutionStateListenerContainer;
import org.apache.gobblin.util.callbacks.CallbacksDispatcher;
import org.slf4j.Logger;

public class JobExecutionStateListeners
implements JobExecutionStateListener,
JobExecutionStateListenerContainer,
Closeable {
    private CallbacksDispatcher<JobExecutionStateListener> _dispatcher;

    public JobExecutionStateListeners(Optional<ExecutorService> execService, Optional<Logger> log) {
        this._dispatcher = new CallbacksDispatcher(execService, log);
    }

    public JobExecutionStateListeners(Logger log) {
        this._dispatcher = new CallbacksDispatcher(log);
    }

    public JobExecutionStateListeners() {
        this._dispatcher = new CallbacksDispatcher();
    }

    @Override
    public void registerStateListener(JobExecutionStateListener listener) {
        this._dispatcher.addListener((Object)listener);
    }

    @Override
    public void unregisterStateListener(JobExecutionStateListener listener) {
        this._dispatcher.removeListener((Object)listener);
    }

    @Override
    public void onStatusChange(JobExecutionState state, JobState.RunningState previousStatus, JobState.RunningState newStatus) {
        try {
            this._dispatcher.execCallbacks((Function)new JobExecutionStateListener.StatusChangeCallback(state, previousStatus, newStatus));
        }
        catch (InterruptedException e) {
            this._dispatcher.getLog().warn("onStatusChange interrupted.");
        }
    }

    @Override
    public void onStageTransition(JobExecutionState state, String previousStage, String newStage) {
        try {
            this._dispatcher.execCallbacks((Function)new JobExecutionStateListener.StageTransitionCallback(state, previousStage, newStage));
        }
        catch (InterruptedException e) {
            this._dispatcher.getLog().warn("onStageTransition interrupted.");
        }
    }

    @Override
    public void onMetadataChange(JobExecutionState state, String key, Object oldValue, Object newValue) {
        try {
            this._dispatcher.execCallbacks((Function)new JobExecutionStateListener.MetadataChangeCallback(state, key, oldValue, newValue));
        }
        catch (InterruptedException e) {
            this._dispatcher.getLog().warn("onMetadataChange interrupted.");
        }
    }

    @Override
    public void registerWeakStateListener(JobExecutionStateListener listener) {
        this._dispatcher.addWeakListener((Object)listener);
    }

    @Override
    public void close() throws IOException {
        this._dispatcher.close();
    }
}

