/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.scheduler;

import java.util.Map;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.MDC;

public abstract class BaseGobblinJob
implements Job {
    private final Map<String, String> mdcContext = MDC.getCopyOfContextMap();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        Map originalContext = MDC.getCopyOfContextMap();
        if (this.mdcContext != null) {
            MDC.setContextMap(this.mdcContext);
        }
        try {
            this.executeImpl(context);
        }
        finally {
            if (originalContext != null) {
                MDC.setContextMap((Map)originalContext);
            } else {
                MDC.clear();
            }
        }
    }

    protected abstract void executeImpl(JobExecutionContext var1) throws JobExecutionException;
}

