/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.scheduler;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.gobblin.runtime.JobException;
import org.apache.gobblin.runtime.listeners.EmailNotificationJobListener;
import org.apache.gobblin.runtime.listeners.RunOnceJobListener;
import org.apache.gobblin.scheduler.JobScheduler;
import org.apache.gobblin.util.PathUtils;
import org.apache.gobblin.util.SchedulerUtils;
import org.apache.gobblin.util.filesystem.PathAlterationListenerAdaptor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathAlterationListenerAdaptorForMonitor
extends PathAlterationListenerAdaptor {
    private static final Logger LOG = LoggerFactory.getLogger(JobScheduler.class);
    Path jobConfigFileDirPath;
    JobScheduler jobScheduler;
    private final Map<Path, String> jobNameMap;

    PathAlterationListenerAdaptorForMonitor(Path jobConfigFileDirPath, JobScheduler jobScheduler) {
        this.jobConfigFileDirPath = jobConfigFileDirPath;
        this.jobScheduler = jobScheduler;
        this.jobNameMap = Maps.newConcurrentMap();
    }

    private Path getJobPath(Properties jobProps) {
        return PathUtils.getPathWithoutSchemeAndAuthority((Path)new Path(jobProps.getProperty("job.config.path")));
    }

    public void addToJobNameMap(Properties jobProps) {
        this.jobNameMap.put(this.getJobPath(jobProps), jobProps.getProperty("job.name"));
    }

    public void loadNewJobConfigAndHandleNewJob(Path path, JobScheduler.Action action) {
        String customizedInfo = "";
        try {
            Properties jobProps = SchedulerUtils.loadGenericJobConfig(this.jobScheduler.properties, path, this.jobConfigFileDirPath);
            LOG.debug("Loaded job properties: {}", (Object)jobProps);
            switch (action) {
                case SCHEDULE: {
                    boolean runOnce = Boolean.valueOf(jobProps.getProperty("job.runonce", "false"));
                    customizedInfo = "schedule";
                    this.addToJobNameMap(jobProps);
                    this.jobScheduler.scheduleJob(jobProps, runOnce ? new RunOnceJobListener() : new EmailNotificationJobListener());
                    break;
                }
                case RESCHEDULE: {
                    customizedInfo = "reschedule";
                    this.rescheduleJob(jobProps);
                    break;
                }
                case UNSCHEDULE: {
                    throw new RuntimeException("Should not call loadNewJobConfigAndHandleNewJob for unscheduling jobs.");
                }
            }
        }
        catch (IOException | ConfigurationException e) {
            LOG.error("Failed to load from job configuration file " + path.toString(), e);
        }
        catch (JobException je) {
            LOG.error("Failed to " + customizedInfo + " new job loaded from job configuration file " + path.toString(), (Throwable)je);
        }
    }

    public void loadNewCommonConfigAndHandleNewJob(Path path, JobScheduler.Action action) {
        String customizedInfoAction = "";
        String customizedInfoResult = "";
        try {
            for (Properties jobProps : SchedulerUtils.loadGenericJobConfigs(this.jobScheduler.properties, path, this.jobConfigFileDirPath)) {
                try {
                    switch (action) {
                        case SCHEDULE: {
                            boolean runOnce = Boolean.valueOf(jobProps.getProperty("job.runonce", "false"));
                            customizedInfoAction = "schedule";
                            customizedInfoResult = "creation or equivalent action";
                            this.addToJobNameMap(jobProps);
                            this.jobScheduler.scheduleJob(jobProps, runOnce ? new RunOnceJobListener() : new EmailNotificationJobListener());
                            break;
                        }
                        case RESCHEDULE: {
                            customizedInfoAction = "reschedule";
                            customizedInfoResult = "change";
                            this.rescheduleJob(jobProps);
                            break;
                        }
                        case UNSCHEDULE: {
                            throw new RuntimeException("Should not call loadNewCommonConfigAndHandleNewJob for unscheduling jobs.");
                        }
                    }
                }
                catch (JobException je) {
                    LOG.error("Failed to " + customizedInfoAction + " job reloaded from job configuration file " + jobProps.getProperty("job.config.path"), (Throwable)je);
                }
            }
        }
        catch (IOException | ConfigurationException e) {
            LOG.error("Failed to reload job configuration files affected by " + customizedInfoResult + " to " + path.toString(), e);
        }
    }

    public void onFileCreate(Path path) {
        String fileExtension = path.getName().substring(path.getName().lastIndexOf(46) + 1);
        String noExtFileName = path.getName().substring(0, path.getName().lastIndexOf(46));
        if (fileExtension.equalsIgnoreCase("properties")) {
            try {
                if (this.checkCommonPropExistance(path.getParent(), noExtFileName)) {
                    return;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            LOG.info("Detected creation of common properties file" + path.toString());
            this.loadNewCommonConfigAndHandleNewJob(path, JobScheduler.Action.RESCHEDULE);
            return;
        }
        if (!this.jobScheduler.jobConfigFileExtensions.contains(fileExtension)) {
            return;
        }
        LOG.info("Detected new job configuration file " + path.toString());
        this.loadNewJobConfigAndHandleNewJob(path, JobScheduler.Action.SCHEDULE);
    }

    public void onFileChange(Path path) {
        String fileExtension = path.getName().substring(path.getName().lastIndexOf(46) + 1);
        if (fileExtension.equalsIgnoreCase("properties")) {
            LOG.info("Detected change to common properties file " + path.toString());
            this.loadNewCommonConfigAndHandleNewJob(path, JobScheduler.Action.RESCHEDULE);
            return;
        }
        if (!this.jobScheduler.jobConfigFileExtensions.contains(fileExtension)) {
            return;
        }
        LOG.info("Detected change to job configuration file " + path.toString());
        this.loadNewJobConfigAndHandleNewJob(path, JobScheduler.Action.RESCHEDULE);
    }

    public void onFileDelete(Path path) {
        String fileExtension = path.getName().substring(path.getName().lastIndexOf(46) + 1);
        if (fileExtension.equalsIgnoreCase("properties")) {
            LOG.info("Detected deletion of common properties file " + path.toString());
            this.loadNewCommonConfigAndHandleNewJob(path, JobScheduler.Action.RESCHEDULE);
            return;
        }
        if (!this.jobScheduler.jobConfigFileExtensions.contains(fileExtension)) {
            return;
        }
        LOG.info("Detected deletion of job configuration file " + path.toString());
        this.unscheduleJobAtPath(path);
    }

    private void unscheduleJobAtPath(Path path) {
        try {
            Path pathWithoutSchemeOrAuthority = PathUtils.getPathWithoutSchemeAndAuthority((Path)path);
            String jobName = this.jobNameMap.get(pathWithoutSchemeOrAuthority);
            if (jobName == null) {
                LOG.info("Could not find a scheduled job to unschedule with path " + pathWithoutSchemeOrAuthority);
                return;
            }
            LOG.info("Unscheduling job " + jobName);
            this.jobScheduler.unscheduleJob(jobName);
            this.jobNameMap.remove(pathWithoutSchemeOrAuthority);
        }
        catch (JobException je) {
            LOG.error("Could not unschedule job " + this.jobNameMap.get(path));
        }
    }

    private void rescheduleJob(Properties jobProps) throws JobException {
        boolean runOnce;
        String jobName = jobProps.getProperty("job.name");
        Path jobPath = this.getJobPath(jobProps);
        if (this.jobNameMap.containsKey(jobPath)) {
            this.jobScheduler.unscheduleJob(this.jobNameMap.get(jobPath));
            this.jobNameMap.remove(jobPath);
        }
        this.jobScheduler.scheduleJob(jobProps, (runOnce = Boolean.valueOf(jobProps.getProperty("job.runonce", "false")).booleanValue()) ? new RunOnceJobListener() : new EmailNotificationJobListener());
        this.addToJobNameMap(jobProps);
        LOG.debug("[JobScheduler] The new job " + jobName + " is rescheduled.");
    }

    private boolean checkCommonPropExistance(Path rootPath, String noExtFileName) throws IOException {
        FileStatus[] children;
        Configuration conf = new Configuration();
        for (FileStatus aChild : children = rootPath.getFileSystem(conf).listStatus(rootPath)) {
            if (!aChild.getPath().getName().contains(noExtFileName)) continue;
            return false;
        }
        return true;
    }
}

