/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.monitoring;

import org.apache.gobblin.annotation.Alpha;

@Alpha
public class JobStatus {
    private final String jobName;
    private final String jobGroup;
    private final long jobExecutionId;
    private final long flowExecutionId;
    private final String flowName;
    private final String flowGroup;
    private final String eventName;
    private final long startTime;
    private final long endTime;
    private final String message;
    private final long processedCount;
    private final String lowWatermark;
    private final String highWatermark;

    JobStatus(String jobName, String jobGroup, long jobExecutionId, long flowExecutionId, String flowName, String flowGroup, String eventName, long startTime, long endTime, String message, long processedCount, String lowWatermark, String highWatermark) {
        this.jobName = jobName;
        this.jobGroup = jobGroup;
        this.jobExecutionId = jobExecutionId;
        this.flowExecutionId = flowExecutionId;
        this.flowName = flowName;
        this.flowGroup = flowGroup;
        this.eventName = eventName;
        this.startTime = startTime;
        this.endTime = endTime;
        this.message = message;
        this.processedCount = processedCount;
        this.lowWatermark = lowWatermark;
        this.highWatermark = highWatermark;
    }

    public static JobStatusBuilder builder() {
        return new JobStatusBuilder();
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getJobGroup() {
        return this.jobGroup;
    }

    public long getJobExecutionId() {
        return this.jobExecutionId;
    }

    public long getFlowExecutionId() {
        return this.flowExecutionId;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public String getFlowGroup() {
        return this.flowGroup;
    }

    public String getEventName() {
        return this.eventName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String getMessage() {
        return this.message;
    }

    public long getProcessedCount() {
        return this.processedCount;
    }

    public String getLowWatermark() {
        return this.lowWatermark;
    }

    public String getHighWatermark() {
        return this.highWatermark;
    }

    public static class JobStatusBuilder {
        private String jobName;
        private String jobGroup;
        private long jobExecutionId;
        private long flowExecutionId;
        private String flowName;
        private String flowGroup;
        private String eventName;
        private long startTime;
        private long endTime;
        private String message;
        private long processedCount;
        private String lowWatermark;
        private String highWatermark;

        JobStatusBuilder() {
        }

        public JobStatusBuilder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public JobStatusBuilder jobGroup(String jobGroup) {
            this.jobGroup = jobGroup;
            return this;
        }

        public JobStatusBuilder jobExecutionId(long jobExecutionId) {
            this.jobExecutionId = jobExecutionId;
            return this;
        }

        public JobStatusBuilder flowExecutionId(long flowExecutionId) {
            this.flowExecutionId = flowExecutionId;
            return this;
        }

        public JobStatusBuilder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public JobStatusBuilder flowGroup(String flowGroup) {
            this.flowGroup = flowGroup;
            return this;
        }

        public JobStatusBuilder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public JobStatusBuilder startTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public JobStatusBuilder endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public JobStatusBuilder message(String message) {
            this.message = message;
            return this;
        }

        public JobStatusBuilder processedCount(long processedCount) {
            this.processedCount = processedCount;
            return this;
        }

        public JobStatusBuilder lowWatermark(String lowWatermark) {
            this.lowWatermark = lowWatermark;
            return this;
        }

        public JobStatusBuilder highWatermark(String highWatermark) {
            this.highWatermark = highWatermark;
            return this;
        }

        public JobStatus build() {
            return new JobStatus(this.jobName, this.jobGroup, this.jobExecutionId, this.flowExecutionId, this.flowName, this.flowGroup, this.eventName, this.startTime, this.endTime, this.message, this.processedCount, this.lowWatermark, this.highWatermark);
        }

        public String toString() {
            return "JobStatus.JobStatusBuilder(jobName=" + this.jobName + ", jobGroup=" + this.jobGroup + ", jobExecutionId=" + this.jobExecutionId + ", flowExecutionId=" + this.flowExecutionId + ", flowName=" + this.flowName + ", flowGroup=" + this.flowGroup + ", eventName=" + this.eventName + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", message=" + this.message + ", processedCount=" + this.processedCount + ", lowWatermark=" + this.lowWatermark + ", highWatermark=" + this.highWatermark + ")";
        }
    }
}

