/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.avro;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.MetadataConverterWrapper;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.avro.AvroToJsonBytesConverter;
import org.apache.gobblin.metadata.types.Metadata;

public class AvroToJsonBytesWithMetadataConverter
extends MetadataConverterWrapper<Schema, String, GenericRecord, byte[]> {
    private String contentType = null;

    public AvroToJsonBytesWithMetadataConverter() {
        super((Converter)new AvroToJsonBytesConverter());
    }

    public String convertSchema(Schema inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        String schema = (String)super.convertSchema((Object)inputSchema, workUnit);
        this.contentType = inputSchema.getFullName() + "+json";
        return schema;
    }

    protected Metadata convertMetadata(Metadata metadata) {
        Metadata md = super.convertMetadata(metadata);
        if (md.getGlobalMetadata().getContentType() == null) {
            md.getGlobalMetadata().setContentType(this.contentType);
        }
        return md;
    }
}

