/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.Striped;
import java.util.concurrent.locks.Lock;
import org.apache.gobblin.util.AutoCloseableLock;

public class HiveLock {
    private static final Joiner JOINER = Joiner.on((char)' ').skipNulls();
    private final Striped<Lock> locks = Striped.lazyWeakLock((int)Integer.MAX_VALUE);

    public AutoCloseableLock getDbLock(String dbName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dbName) ? 1 : 0) != 0);
        return new AutoCloseableLock((Lock)this.locks.get((Object)dbName));
    }

    public AutoCloseableLock getTableLock(String dbName, String tableName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dbName) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableName) ? 1 : 0) != 0);
        return new AutoCloseableLock((Lock)this.locks.get((Object)JOINER.join((Object)dbName, (Object)tableName, new Object[0])));
    }

    public AutoCloseableLock getPartitionLock(String dbName, String tableName, Iterable<String> partitionValues) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dbName) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableName) ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)partitionValues.iterator().hasNext());
        return new AutoCloseableLock((Lock)this.locks.get((Object)JOINER.join((Object)dbName, (Object)tableName, new Object[]{JOINER.join(partitionValues)})));
    }
}

