/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive;

import com.google.common.base.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaStoreClientFactory
extends BasePooledObjectFactory<IMetaStoreClient> {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMetaStoreClientFactory.class);
    public static final String HIVE_METASTORE_TOKEN_SIGNATURE = "hive.metastore.token.signature";
    private HiveConf hiveConf;

    public HiveMetaStoreClientFactory(Optional<String> hcatURI) {
        this(HiveMetaStoreClientFactory.getHiveConf(hcatURI));
    }

    private static HiveConf getHiveConf(Optional<String> hcatURI) {
        HiveConf hiveConf = new HiveConf();
        if (hcatURI.isPresent() && StringUtils.isNotBlank((String)((String)hcatURI.get()))) {
            hiveConf.setVar(HiveConf.ConfVars.METASTOREURIS, (String)hcatURI.get());
            hiveConf.set(HIVE_METASTORE_TOKEN_SIGNATURE, (String)hcatURI.get());
        }
        return hiveConf;
    }

    public HiveMetaStoreClientFactory(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
    }

    public HiveMetaStoreClientFactory() {
        this((Optional<String>)Optional.absent());
    }

    private IMetaStoreClient createMetaStoreClient() throws MetaException {
        HiveMetaHookLoader hookLoader = new HiveMetaHookLoader(){

            public HiveMetaHook getHook(Table tbl) throws MetaException {
                if (tbl == null) {
                    return null;
                }
                try {
                    HiveStorageHandler storageHandler = HiveUtils.getStorageHandler((Configuration)HiveMetaStoreClientFactory.this.hiveConf, (String)((String)tbl.getParameters().get("storage_handler")));
                    return storageHandler == null ? null : storageHandler.getMetaHook();
                }
                catch (HiveException e) {
                    LOG.error(e.toString());
                    throw new MetaException("Failed to get storage handler: " + (Object)((Object)e));
                }
            }
        };
        return RetryingMetaStoreClient.getProxy((HiveConf)this.hiveConf, (HiveMetaHookLoader)hookLoader, (String)HiveMetaStoreClient.class.getName());
    }

    public IMetaStoreClient create() {
        try {
            return this.createMetaStoreClient();
        }
        catch (MetaException e) {
            throw new RuntimeException("Unable to create " + IMetaStoreClient.class.getSimpleName(), e);
        }
    }

    public PooledObject<IMetaStoreClient> wrap(IMetaStoreClient client) {
        return new DefaultPooledObject((Object)client);
    }

    public void destroyObject(PooledObject<IMetaStoreClient> client) {
        ((IMetaStoreClient)client.getObject()).close();
    }

    public HiveConf getHiveConf() {
        return this.hiveConf;
    }
}

