/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Arrays;
import org.apache.gobblin.commit.CommitStep;
import org.apache.gobblin.hive.HiveRegProps;
import org.apache.gobblin.hive.HiveRegister;
import org.apache.gobblin.hive.HiveTable;
import org.apache.gobblin.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;

public class PartitionDeregisterStep
implements CommitStep {
    private Table table;
    private Partition partition;
    private final Optional<String> metastoreURI;
    private final HiveRegProps props;

    public boolean isCompleted() throws IOException {
        return false;
    }

    public void execute() throws IOException {
        HiveTable hiveTable = HiveMetaStoreUtils.getHiveTable(this.table);
        try (HiveRegister hiveRegister = HiveRegister.get(this.props, this.metastoreURI);){
            hiveRegister.dropPartitionIfExists(this.partition.getDbName(), this.partition.getTableName(), hiveTable.getPartitionKeys(), this.partition.getValues());
        }
    }

    public String toString() {
        return String.format("Deregister partition %s.%s %s on Hive metastore %s.", this.partition.getDbName(), this.partition.getTableName(), Arrays.toString(this.partition.getValues().toArray()), this.metastoreURI.isPresent() ? this.metastoreURI.get() : "default");
    }

    @ConstructorProperties(value={"table", "partition", "metastoreURI", "props"})
    public PartitionDeregisterStep(Table table, Partition partition, Optional<String> metastoreURI, HiveRegProps props) {
        this.table = table;
        this.partition = partition;
        this.metastoreURI = metastoreURI;
        this.props = props;
    }
}

