/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive.avro;

import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import org.apache.avro.Schema;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.hive.HiveRegistrationUnit;
import org.apache.gobblin.hive.HiveSerDeManager;
import org.apache.gobblin.hive.HiveSerDeWrapper;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.util.AvroUtils;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class HiveAvroSerDeManager
extends HiveSerDeManager {
    private static final Logger log = LoggerFactory.getLogger(HiveAvroSerDeManager.class);
    public static final String SCHEMA_LITERAL = "avro.schema.literal";
    public static final String SCHEMA_URL = "avro.schema.url";
    public static final String USE_SCHEMA_FILE = "use.schema.file";
    public static final boolean DEFAULT_USE_SCHEMA_FILE = false;
    public static final String SCHEMA_FILE_NAME = "schema.file.name";
    public static final String DEFAULT_SCHEMA_FILE_NAME = "_schema.avsc";
    public static final String SCHEMA_LITERAL_LENGTH_LIMIT = "schema.literal.length.limit";
    public static final int DEFAULT_SCHEMA_LITERAL_LENGTH_LIMIT = 4000;
    public static final String HIVE_SPEC_SCHEMA_READING_TIMER = "hiveAvroSerdeManager.schemaReadTimer";
    public static final String HIVE_SPEC_SCHEMA_WRITING_TIMER = "hiveAvroSerdeManager.schemaWriteTimer";
    protected final FileSystem fs;
    protected final boolean useSchemaFile;
    protected final String schemaFileName;
    protected final int schemaLiteralLengthLimit;
    protected final HiveSerDeWrapper serDeWrapper = HiveSerDeWrapper.get("AVRO");
    private final MetricContext metricContext;

    public HiveAvroSerDeManager(State props) throws IOException {
        super(props);
        this.fs = props.contains("hive.registration.fs.uri") ? FileSystem.get((URI)URI.create(props.getProp("hive.registration.fs.uri")), (Configuration)HadoopUtils.getConfFromState((State)props)) : FileSystem.get((Configuration)HadoopUtils.getConfFromState((State)props));
        this.useSchemaFile = props.getPropAsBoolean(USE_SCHEMA_FILE, false);
        this.schemaFileName = props.getProp(SCHEMA_FILE_NAME, DEFAULT_SCHEMA_FILE_NAME);
        this.schemaLiteralLengthLimit = props.getPropAsInt(SCHEMA_LITERAL_LENGTH_LIMIT, 4000);
        this.metricContext = Instrumented.getMetricContext((State)props, HiveAvroSerDeManager.class);
    }

    @Override
    public void addSerDeProperties(Path path, HiveRegistrationUnit hiveUnit) throws IOException {
        hiveUnit.setSerDeType(this.serDeWrapper.getSerDe().getClass().getName());
        hiveUnit.setInputFormat(this.serDeWrapper.getInputFormatClassName());
        hiveUnit.setOutputFormat(this.serDeWrapper.getOutputFormatClassName());
        this.addSchemaProperties(path, hiveUnit);
    }

    @Override
    public void addSerDeProperties(HiveRegistrationUnit source, HiveRegistrationUnit target) throws IOException {
        if (source.getSerDeType().isPresent()) {
            target.setSerDeType((String)source.getSerDeType().get());
        }
        if (source.getInputFormat().isPresent()) {
            target.setInputFormat((String)source.getInputFormat().get());
        }
        if (source.getOutputFormat().isPresent()) {
            target.setOutputFormat((String)source.getOutputFormat().get());
        }
        if (source.getSerDeProps().contains(SCHEMA_LITERAL)) {
            target.setSerDeProp(SCHEMA_LITERAL, source.getSerDeProps().getProp(SCHEMA_LITERAL));
        }
        if (source.getSerDeProps().contains(SCHEMA_URL)) {
            target.setSerDeProp(SCHEMA_URL, source.getSerDeProps().getProp(SCHEMA_URL));
        }
    }

    private void addSchemaProperties(Path path, HiveRegistrationUnit hiveUnit) throws IOException {
        Preconditions.checkArgument((boolean)this.fs.getFileStatus(path).isDirectory(), (Object)(path + " is not a directory."));
        Path schemaFile = new Path(path, this.schemaFileName);
        if (this.useSchemaFile) {
            hiveUnit.setSerDeProp(SCHEMA_URL, schemaFile.toString());
        } else {
            Schema schema;
            try (Timer.Context context = this.metricContext.timer(HIVE_SPEC_SCHEMA_READING_TIMER).time();){
                schema = this.getDirectorySchema(path);
            }
            context = this.metricContext.timer(HIVE_SPEC_SCHEMA_WRITING_TIMER).time();
            var6_5 = null;
            try {
                this.addSchemaFromAvroFile(schema, schemaFile, hiveUnit);
            }
            catch (Throwable throwable) {
                var6_5 = throwable;
                throw throwable;
            }
            finally {
                if (context != null) {
                    if (var6_5 != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable) {
                            var6_5.addSuppressed(throwable);
                        }
                    } else {
                        context.close();
                    }
                }
            }
        }
    }

    protected Schema getDirectorySchema(Path directory) throws IOException {
        return AvroUtils.getDirectorySchema((Path)directory, (FileSystem)this.fs, (boolean)true);
    }

    protected void addSchemaFromAvroFile(Schema schema, Path schemaFile, HiveRegistrationUnit hiveUnit) throws IOException {
        Preconditions.checkNotNull((Object)schema);
        String schemaStr = schema.toString();
        if (schemaStr.length() <= this.schemaLiteralLengthLimit) {
            hiveUnit.setSerDeProp(SCHEMA_LITERAL, schema.toString());
        } else {
            AvroUtils.writeSchemaToFile((Schema)schema, (Path)schemaFile, (FileSystem)this.fs, (boolean)true);
            log.info("Using schema file " + schemaFile.toString());
            hiveUnit.setSerDeProp(SCHEMA_URL, schemaFile.toString());
        }
    }

    @Override
    public void updateSchema(HiveRegistrationUnit existingUnit, HiveRegistrationUnit newUnit) throws IOException {
        Preconditions.checkArgument((newUnit.getSerDeProps().contains(SCHEMA_LITERAL) || newUnit.getSerDeProps().contains(SCHEMA_URL) ? 1 : 0) != 0);
        if (newUnit.getSerDeProps().contains(SCHEMA_LITERAL)) {
            existingUnit.setSerDeProp(SCHEMA_LITERAL, newUnit.getSerDeProps().getProp(SCHEMA_LITERAL));
        } else {
            existingUnit.setSerDeProp(SCHEMA_URL, newUnit.getSerDeProps().getProp(SCHEMA_URL));
        }
    }

    @Override
    public boolean haveSameSchema(HiveRegistrationUnit unit1, HiveRegistrationUnit unit2) {
        if (unit1.getSerDeProps().contains(SCHEMA_LITERAL) && unit2.getSerDeProps().contains(SCHEMA_LITERAL)) {
            return unit1.getSerDeProps().getProp(SCHEMA_LITERAL).equals(unit2.getSerDeProps().getProp(SCHEMA_LITERAL));
        }
        if (unit1.getSerDeProps().contains(SCHEMA_URL) && unit2.getSerDeProps().contains(SCHEMA_URL)) {
            return unit1.getSerDeProps().getProp(SCHEMA_URL).equals(unit2.getSerDeProps().getProp(SCHEMA_URL));
        }
        return false;
    }
}

