/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter;

import com.google.common.base.Optional;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.metrics.kafka.KafkaSchemaRegistry;
import org.apache.gobblin.metrics.kafka.KafkaSchemaRegistryFactory;
import org.apache.gobblin.util.AvroUtils;

public abstract class BaseEnvelopeSchemaConverter<P>
extends Converter<Schema, Schema, GenericRecord, GenericRecord> {
    public static final String CONF_PREFIX = "converter.envelopeSchemaConverter.";
    public static final String PAYLOAD_SCHEMA_ID_FIELD = "converter.envelopeSchemaConverter.schemaIdField";
    public static final String PAYLOAD_FIELD = "converter.envelopeSchemaConverter.payloadField";
    public static final String PAYLOAD_SCHEMA_TOPIC = "converter.envelopeSchemaConverter.payloadSchemaTopic";
    public static final String KAFKA_REGISTRY_FACTORY = "converter.envelopeSchemaConverter.kafkaRegistryFactory";
    public static final String DEFAULT_PAYLOAD_FIELD = "payload";
    public static final String DEFAULT_PAYLOAD_SCHEMA_ID_FIELD = "payloadSchemaId";
    public static final String DEFAULT_KAFKA_SCHEMA_REGISTRY_FACTORY_CLASS = "org.apache.gobblin.metrics.kafka.KafkaAvroSchemaRegistryFactory";
    protected String payloadSchemaIdField;
    protected String payloadField;
    protected String payloadSchemaTopic;
    protected GenericDatumReader<P> latestPayloadReader;
    protected KafkaSchemaRegistry registry;

    public BaseEnvelopeSchemaConverter init(WorkUnitState workUnit) {
        super.init(workUnit);
        this.payloadSchemaIdField = workUnit.getProp(PAYLOAD_SCHEMA_ID_FIELD, DEFAULT_PAYLOAD_SCHEMA_ID_FIELD);
        this.payloadField = workUnit.getProp(PAYLOAD_FIELD, DEFAULT_PAYLOAD_FIELD);
        if (!workUnit.contains(PAYLOAD_SCHEMA_TOPIC)) {
            throw new RuntimeException("Configuration not found: converter.envelopeSchemaConverter.payloadSchemaTopic");
        }
        this.payloadSchemaTopic = workUnit.getProp(PAYLOAD_SCHEMA_TOPIC);
        String registryFactoryField = workUnit.getProp(KAFKA_REGISTRY_FACTORY, DEFAULT_KAFKA_SCHEMA_REGISTRY_FACTORY_CLASS);
        try {
            KafkaSchemaRegistryFactory registryFactory = (KafkaSchemaRegistryFactory)Class.forName(registryFactoryField).newInstance();
            this.registry = registryFactory.create(workUnit.getProperties());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Deprecated
    protected Schema getPayloadSchema(GenericRecord inputRecord) throws Exception {
        return this.getFieldSchema(inputRecord, this.payloadSchemaIdField);
    }

    protected Schema getFieldSchema(GenericRecord record, String schemaIdLocation) throws Exception {
        Optional schemaIdValue = AvroUtils.getFieldValue((GenericRecord)record, (String)schemaIdLocation);
        if (!schemaIdValue.isPresent()) {
            throw new Exception("Schema id with key " + schemaIdLocation + " not found in the record");
        }
        String schemaKey = String.valueOf(schemaIdValue.get());
        return (Schema)this.registry.getSchemaByKey(schemaKey);
    }

    @Deprecated
    protected byte[] getPayloadBytes(GenericRecord inputRecord) {
        try {
            return this.getFieldAsBytes(inputRecord, this.payloadField);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected byte[] getFieldAsBytes(GenericRecord record, String fieldLocation) throws Exception {
        Optional bytesValue = AvroUtils.getFieldValue((GenericRecord)record, (String)fieldLocation);
        if (!bytesValue.isPresent()) {
            throw new Exception("Bytes value with key " + fieldLocation + " not found in the record");
        }
        ByteBuffer bb = (ByteBuffer)bytesValue.get();
        if (bb.hasArray()) {
            return bb.array();
        }
        byte[] payloadBytes = new byte[bb.remaining()];
        bb.get(payloadBytes);
        return payloadBytes;
    }

    protected Schema fetchLatestPayloadSchema() throws Exception {
        Schema latestPayloadSchema = (Schema)this.registry.getLatestSchemaByTopic(this.payloadSchemaTopic);
        this.latestPayloadReader = new GenericDatumReader(latestPayloadSchema);
        return latestPayloadSchema;
    }

    protected P upConvertPayload(GenericRecord inputRecord) throws DataConversionException {
        try {
            Schema payloadSchema = this.getPayloadSchema(inputRecord);
            this.latestPayloadReader.setSchema(payloadSchema);
            byte[] payloadBytes = this.getPayloadBytes(inputRecord);
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(payloadBytes, null);
            return (P)this.latestPayloadReader.read(null, (Decoder)decoder);
        }
        catch (Exception e) {
            throw new DataConversionException((Throwable)e);
        }
    }
}

