/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter;

import java.util.ArrayList;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.BaseEnvelopeSchemaConverter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;

public class EnvelopePayloadConverter
extends BaseEnvelopeSchemaConverter<GenericRecord> {
    public static final String DECORATED_PAYLOAD_DOC = "Decorated payload data";

    public Schema convertSchema(Schema inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        ArrayList<Schema.Field> outputSchemaFields = new ArrayList<Schema.Field>();
        for (Schema.Field field : inputSchema.getFields()) {
            outputSchemaFields.add(this.convertFieldSchema(inputSchema, field, workUnit));
        }
        Schema outputSchema = Schema.createRecord((String)inputSchema.getName(), (String)inputSchema.getDoc(), (String)inputSchema.getNamespace(), (boolean)inputSchema.isError());
        outputSchema.setFields(outputSchemaFields);
        return outputSchema;
    }

    protected Schema.Field convertFieldSchema(Schema inputSchema, Schema.Field field, WorkUnitState workUnit) throws SchemaConversionException {
        if (field.name().equals(this.payloadField)) {
            return this.createLatestPayloadField(field);
        }
        return new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultValue(), field.order());
    }

    private Schema.Field createLatestPayloadField(Schema.Field field) throws SchemaConversionException {
        try {
            Schema payloadSchema = this.fetchLatestPayloadSchema();
            return new Schema.Field(field.name(), payloadSchema, DECORATED_PAYLOAD_DOC, field.defaultValue(), field.order());
        }
        catch (Exception e) {
            throw new SchemaConversionException((Throwable)e);
        }
    }

    public Iterable<GenericRecord> convertRecord(Schema outputSchema, GenericRecord inputRecord, WorkUnitState workUnit) throws DataConversionException {
        GenericData.Record outputRecord = new GenericData.Record(outputSchema);
        for (Schema.Field field : inputRecord.getSchema().getFields()) {
            outputRecord.put(field.name(), this.convertFieldValue(outputSchema, field, inputRecord, workUnit));
        }
        return new SingleRecordIterable((Object)outputRecord);
    }

    protected Object convertFieldValue(Schema outputSchema, Schema.Field field, GenericRecord inputRecord, WorkUnitState workUnit) throws DataConversionException {
        if (field.name().equals(this.payloadField)) {
            return this.upConvertPayload(inputRecord);
        }
        return inputRecord.get(field.name());
    }
}

