/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.kafka.schemareg;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.gobblin.kafka.schemareg.KafkaSchemaRegistry;
import org.apache.gobblin.kafka.schemareg.SchemaRegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingKafkaSchemaRegistry<K, S>
implements KafkaSchemaRegistry<K, S> {
    private static final Logger log = LoggerFactory.getLogger(CachingKafkaSchemaRegistry.class);
    private static final int DEFAULT_MAX_SCHEMA_REFERENCES = 10;
    private final KafkaSchemaRegistry<K, S> _kafkaSchemaRegistry;
    private final HashMap<String, Map<S, K>> _namedSchemaCache;
    private final HashMap<K, S> _idBasedCache;
    private final int _maxSchemaReferences;

    public CachingKafkaSchemaRegistry(KafkaSchemaRegistry kafkaSchemaRegistry) {
        this(kafkaSchemaRegistry, 10);
    }

    public CachingKafkaSchemaRegistry(KafkaSchemaRegistry kafkaSchemaRegistry, int maxSchemaReferences) {
        Preconditions.checkArgument((kafkaSchemaRegistry != null ? 1 : 0) != 0, (Object)"KafkaSchemaRegistry cannot be null");
        Preconditions.checkArgument((!kafkaSchemaRegistry.hasInternalCache() ? 1 : 0) != 0, (Object)"SchemaRegistry already has a cache.");
        this._kafkaSchemaRegistry = kafkaSchemaRegistry;
        this._namedSchemaCache = new HashMap();
        this._idBasedCache = new HashMap();
        this._maxSchemaReferences = maxSchemaReferences;
    }

    @Override
    public synchronized K register(String name, S schema) throws IOException, SchemaRegistryException {
        Map<Object, Object> schemaIdMap;
        if (this._namedSchemaCache.containsKey(name)) {
            schemaIdMap = this._namedSchemaCache.get(name);
        } else {
            schemaIdMap = new IdentityHashMap();
            this._namedSchemaCache.put(name, schemaIdMap);
        }
        if (schemaIdMap.containsKey(schema)) {
            return (K)schemaIdMap.get(schema);
        }
        Preconditions.checkState((schemaIdMap.size() < this._maxSchemaReferences ? 1 : 0) != 0, (Object)("Too many schema objects for " + name + ". Cache is overfull."));
        K id = this._kafkaSchemaRegistry.register(name, schema);
        schemaIdMap.put(schema, id);
        this._idBasedCache.put(id, schema);
        return id;
    }

    @Override
    public synchronized S getById(K id) throws IOException, SchemaRegistryException {
        if (this._idBasedCache.containsKey(id)) {
            return this._idBasedCache.get(id);
        }
        S schema = this._kafkaSchemaRegistry.getById(id);
        this._idBasedCache.put(id, schema);
        return schema;
    }

    @Override
    public S getLatestSchema(String name) throws IOException, SchemaRegistryException {
        return this._kafkaSchemaRegistry.getLatestSchema(name);
    }

    @Override
    public boolean hasInternalCache() {
        return true;
    }
}

