/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.kafka;

import com.google.common.base.Optional;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.gobblin.metrics.MetricReport;
import org.apache.gobblin.metrics.kafka.KafkaAvroSchemaRegistry;
import org.apache.gobblin.metrics.kafka.KafkaReporter;
import org.apache.gobblin.metrics.reporter.util.AvroBinarySerializer;
import org.apache.gobblin.metrics.reporter.util.AvroSerializer;
import org.apache.gobblin.metrics.reporter.util.SchemaRegistryVersionWriter;
import org.apache.gobblin.metrics.reporter.util.SchemaVersionWriter;

public class KafkaAvroReporter
extends KafkaReporter {
    protected KafkaAvroReporter(Builder<?> builder, Config config) throws IOException {
        super(builder, config);
        if (((Builder)builder).registry.isPresent()) {
            Schema schema = new Schema.Parser().parse(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("MetricReport.avsc"));
            this.serializer.setSchemaVersionWriter((SchemaVersionWriter)new SchemaRegistryVersionWriter((KafkaAvroSchemaRegistry)((Builder)builder).registry.get(), builder.topic, (Optional<Schema>)Optional.of((Object)schema)));
        }
    }

    @Override
    protected AvroSerializer<MetricReport> createSerializer(SchemaVersionWriter schemaVersionWriter) throws IOException {
        return new AvroBinarySerializer(MetricReport.SCHEMA$, schemaVersionWriter);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends KafkaReporter.Builder<T> {
        private Optional<KafkaAvroSchemaRegistry> registry = Optional.absent();

        public T withSchemaRegistry(KafkaAvroSchemaRegistry registry) {
            this.registry = Optional.of((Object)registry);
            return (T)((Object)((Builder)this.self()));
        }

        @Override
        public KafkaAvroReporter build(String brokers, String topic, Properties props) throws IOException {
            this.brokers = brokers;
            this.topic = topic;
            return new KafkaAvroReporter(this, KafkaReporter.getKafkaAndMetricsConfigFromProperties(props));
        }
    }

    public static class BuilderImpl
    extends Builder<BuilderImpl> {
        protected BuilderImpl self() {
            return this;
        }
    }

    public static class BuilderFactory {
        public static BuilderImpl newBuilder() {
            return new BuilderImpl();
        }
    }
}

