/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.kafka;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Queue;
import org.apache.avro.specific.SpecificRecord;
import org.apache.gobblin.metrics.GobblinTrackingEvent;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.kafka.Pusher;
import org.apache.gobblin.metrics.kafka.PusherUtils;
import org.apache.gobblin.metrics.reporter.EventReporter;
import org.apache.gobblin.metrics.reporter.util.AvroJsonSerializer;
import org.apache.gobblin.metrics.reporter.util.AvroSerializer;
import org.apache.gobblin.metrics.reporter.util.FixedSchemaVersionWriter;
import org.apache.gobblin.metrics.reporter.util.SchemaVersionWriter;

public class KafkaEventReporter
extends EventReporter {
    protected final AvroSerializer<GobblinTrackingEvent> serializer;
    private final Pusher kafkaPusher;

    public KafkaEventReporter(Builder<?> builder) throws IOException {
        super(builder);
        this.serializer = (AvroSerializer)this.closer.register(this.createSerializer((SchemaVersionWriter)new FixedSchemaVersionWriter()));
        if (builder.kafkaPusher.isPresent()) {
            this.kafkaPusher = (Pusher)builder.kafkaPusher.get();
        } else {
            String pusherClassName = (String)builder.pusherClassName.or((Object)"org.apache.gobblin.metrics.kafka.KafkaPusher");
            this.kafkaPusher = PusherUtils.getPusher(pusherClassName, builder.brokers, builder.topic, builder.config);
        }
        this.closer.register((Closeable)this.kafkaPusher);
    }

    public void reportEventQueue(Queue<GobblinTrackingEvent> queue) {
        GobblinTrackingEvent nextEvent;
        ArrayList events = Lists.newArrayList();
        while (null != (nextEvent = queue.poll())) {
            events.add(this.serializer.serializeRecord((SpecificRecord)nextEvent));
        }
        if (!events.isEmpty()) {
            this.kafkaPusher.pushMessages(events);
        }
    }

    protected AvroSerializer<GobblinTrackingEvent> createSerializer(SchemaVersionWriter schemaVersionWriter) throws IOException {
        return new AvroJsonSerializer(GobblinTrackingEvent.SCHEMA$, schemaVersionWriter);
    }

    @Deprecated
    public static Builder<? extends Builder> forContext(MetricContext context) {
        return new BuilderImpl(context);
    }

    public static abstract class Builder<T extends EventReporter.Builder<T>>
    extends EventReporter.Builder<T> {
        protected String brokers;
        protected String topic;
        protected Optional<Pusher> kafkaPusher;
        protected Optional<Config> config = Optional.absent();
        protected Optional<String> pusherClassName = Optional.absent();

        protected Builder(MetricContext context) {
            super(context);
            this.kafkaPusher = Optional.absent();
        }

        public T withKafkaPusher(Pusher pusher) {
            this.kafkaPusher = Optional.of((Object)pusher);
            return (T)this.self();
        }

        public T withConfig(Config config) {
            this.config = Optional.of((Object)config);
            return (T)this.self();
        }

        public T withPusherClassName(String pusherClassName) {
            this.pusherClassName = Optional.of((Object)pusherClassName);
            return (T)this.self();
        }

        public KafkaEventReporter build(String brokers, String topic) throws IOException {
            this.brokers = brokers;
            this.topic = topic;
            return new KafkaEventReporter(this);
        }
    }

    public static class Factory {
        public static BuilderImpl forContext(MetricContext context) {
            return new BuilderImpl(context);
        }
    }

    public static class BuilderImpl
    extends Builder<BuilderImpl> {
        private BuilderImpl(MetricContext context) {
            super(context);
        }

        protected BuilderImpl self() {
            return this;
        }
    }
}

