/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.kafka;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.IOException;
import java.util.Properties;
import org.apache.gobblin.configuration.ConfigurationKeys;
import org.apache.gobblin.metrics.CustomCodahaleReporterFactory;
import org.apache.gobblin.metrics.KafkaReportingFormats;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.RootMetricContext;
import org.apache.gobblin.metrics.kafka.KafkaEventReporter;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaReporterFactory
implements CustomCodahaleReporterFactory {
    private static final Logger log = LoggerFactory.getLogger(KafkaReporterFactory.class);

    public ScheduledReporter newScheduledReporter(MetricRegistry registry, Properties properties) throws IOException {
        KafkaReportingFormats formatEnum;
        boolean eventsEnabled;
        if (!Boolean.valueOf(properties.getProperty("metrics.reporting.kafka.enabled", ConfigurationKeys.DEFAULT_METRICS_REPORTING_KAFKA_ENABLED)).booleanValue()) {
            return null;
        }
        log.info("Reporting metrics to Kafka");
        Optional defaultTopic = Optional.fromNullable((Object)properties.getProperty("metrics.reporting.kafka.topic"));
        Optional metricsTopic = Optional.fromNullable((Object)properties.getProperty("metrics.reporting.kafka.topic.metrics"));
        Optional eventsTopic = Optional.fromNullable((Object)properties.getProperty("metrics.reporting.kafka.topic.events"));
        boolean metricsEnabled = metricsTopic.or(defaultTopic).isPresent();
        if (metricsEnabled) {
            log.info("Reporting metrics to Kafka");
        }
        if (eventsEnabled = eventsTopic.or(defaultTopic).isPresent()) {
            log.info("Reporting events to Kafka");
        }
        try {
            Preconditions.checkArgument((boolean)properties.containsKey("metrics.reporting.kafka.brokers"), (Object)"Kafka metrics brokers missing.");
            Preconditions.checkArgument((boolean)metricsTopic.or(eventsTopic).or(defaultTopic).isPresent(), (Object)"Kafka topic missing.");
        }
        catch (IllegalArgumentException exception) {
            log.error("Not reporting metrics to Kafka due to missing Kafka configuration(s).", (Throwable)exception);
            return null;
        }
        String brokers = properties.getProperty("metrics.reporting.kafka.brokers");
        String reportingFormat = properties.getProperty("metrics.reporting.kafka.format", "json");
        try {
            formatEnum = KafkaReportingFormats.valueOf(reportingFormat.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.warn("Kafka metrics reporting format " + reportingFormat + " not recognized. Will report in json format.", (Throwable)exception);
            formatEnum = KafkaReportingFormats.JSON;
        }
        if (metricsEnabled) {
            try {
                formatEnum.metricReporterBuilder(properties).build(brokers, (String)metricsTopic.or(defaultTopic).get(), properties);
            }
            catch (IOException exception) {
                log.error("Failed to create Kafka metrics reporter. Will not report metrics to Kafka.", (Throwable)exception);
            }
        }
        if (eventsEnabled) {
            try {
                KafkaEventReporter.Builder<?> builder = formatEnum.eventReporterBuilder((MetricContext)RootMetricContext.get(), properties);
                Config allConfig = ConfigUtils.propertiesToConfig((Properties)properties);
                Config kafkaConfig = ConfigUtils.getConfigOrEmpty((Config)allConfig, (String)"metrics.reporting.kafka.config").withFallback((ConfigMergeable)ConfigUtils.getConfigOrEmpty((Config)allConfig, (String)"gobblin.kafka.sharedConfig"));
                builder.withConfig(kafkaConfig);
                builder.withPusherClassName(properties.getProperty("metrics.reporting.kafkaPusherClass", "org.apache.gobblin.metrics.kafka.KafkaPusher"));
                return builder.build(brokers, (String)eventsTopic.or(defaultTopic).get());
            }
            catch (IOException exception) {
                log.error("Failed to create Kafka events reporter. Will not report events to Kafka.", (Throwable)exception);
            }
        }
        log.info("Will start reporting metrics to Kafka");
        return null;
    }
}

