/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.kafka;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.math.LongMath;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.math.RoundingMode;
import java.util.List;
import org.apache.gobblin.source.extractor.Watermark;

public class MultiLongWatermark
implements Watermark {
    private static final Gson GSON = new Gson();
    private final List<Long> values;

    public MultiLongWatermark(MultiLongWatermark other) {
        this.values = Lists.newArrayList(other.values);
    }

    public MultiLongWatermark(List<Long> values) {
        this.values = Lists.newArrayList(values);
    }

    public void increment(int idx) {
        Preconditions.checkElementIndex((int)idx, (int)this.values.size());
        Preconditions.checkArgument((this.values.get(idx) < Long.MAX_VALUE ? 1 : 0) != 0);
        this.values.set(idx, this.values.get(idx) + 1L);
    }

    public JsonElement toJson() {
        return GSON.toJsonTree((Object)this);
    }

    public short calculatePercentCompletion(Watermark lowWatermark, Watermark highWatermark) {
        Preconditions.checkArgument((lowWatermark instanceof MultiLongWatermark && highWatermark instanceof MultiLongWatermark ? 1 : 0) != 0, (Object)String.format("Arguments of %s.%s must be of type %s", MultiLongWatermark.class.getSimpleName(), Thread.currentThread().getStackTrace()[1].getMethodName(), MultiLongWatermark.class.getSimpleName()));
        long pulled = ((MultiLongWatermark)lowWatermark).getGap(this);
        long all = ((MultiLongWatermark)lowWatermark).getGap((MultiLongWatermark)highWatermark);
        Preconditions.checkState((all > 0L ? 1 : 0) != 0);
        long percent = Math.min(100L, LongMath.divide((long)(pulled * 100L), (long)all, (RoundingMode)RoundingMode.HALF_UP));
        return (short)percent;
    }

    public long getGap(MultiLongWatermark highWatermark) {
        Preconditions.checkNotNull((Object)highWatermark);
        Preconditions.checkArgument((this.values.size() == highWatermark.values.size() ? 1 : 0) != 0);
        long diff = 0L;
        for (int i = 0; i < this.values.size(); ++i) {
            Preconditions.checkArgument((this.values.get(i) <= highWatermark.values.get(i) ? 1 : 0) != 0);
            diff += highWatermark.values.get(i) - this.values.get(i);
        }
        return diff;
    }

    public int size() {
        return this.values.size();
    }

    public long get(int idx) {
        Preconditions.checkElementIndex((int)idx, (int)this.values.size());
        return this.values.get(idx);
    }

    public long set(int idx, long value) {
        Preconditions.checkElementIndex((int)idx, (int)this.values.size());
        return this.values.set(idx, value);
    }

    public String toString() {
        return this.values.toString();
    }
}

