/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.kafka.workunit.packer;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaPartition;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaUtils;
import org.apache.gobblin.source.extractor.extract.kafka.workunit.packer.KafkaWorkUnitSizeEstimator;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaAvgRecordSizeBasedWorkUnitSizeEstimator
implements KafkaWorkUnitSizeEstimator {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaAvgRecordSizeBasedWorkUnitSizeEstimator.class);
    private static final long DEFAULT_AVG_RECORD_SIZE = 1024L;
    private final Map<KafkaPartition, Long> estAvgSizes = Maps.newHashMap();

    KafkaAvgRecordSizeBasedWorkUnitSizeEstimator(SourceState state) {
        this.readPreAvgRecordSizes(state);
    }

    @Override
    public double calcEstimatedSize(WorkUnit workUnit) {
        long avgSize = this.getEstAvgSizeForPartition(KafkaUtils.getPartition((State)workUnit));
        long numOfRecords = workUnit.getPropAsLong("workunit.high.water.mark") - workUnit.getPropAsLong("workunit.low.water.mark");
        return (double)avgSize * (double)numOfRecords;
    }

    private long getEstAvgSizeForPartition(KafkaPartition partition) {
        if (this.estAvgSizes.containsKey(partition)) {
            LOG.info(String.format("Estimated avg record size for partition %s is %d", partition, this.estAvgSizes.get(partition)));
            return this.estAvgSizes.get(partition);
        }
        LOG.warn(String.format("Avg record size for partition %s not available, using default size %d", partition, 1024L));
        return 1024L;
    }

    private void readPreAvgRecordSizes(SourceState state) {
        this.estAvgSizes.clear();
        for (WorkUnitState workUnitState : state.getPreviousWorkUnitStates()) {
            List<KafkaPartition> partitions = KafkaUtils.getPartitions((State)workUnitState);
            for (KafkaPartition partition : partitions) {
                if (!KafkaUtils.containsPartitionAvgRecordSize((State)workUnitState, partition)) continue;
                long previousAvgSize = KafkaUtils.getPartitionAvgRecordSize((State)workUnitState, partition);
                this.estAvgSizes.put(partition, previousAvgSize);
            }
        }
    }
}

