/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.kafka.workunit.packer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.source.extractor.extract.AbstractSource;
import org.apache.gobblin.source.extractor.extract.kafka.workunit.packer.KafkaWorkUnitPacker;
import org.apache.gobblin.source.workunit.MultiWorkUnit;
import org.apache.gobblin.source.workunit.WorkUnit;

public class KafkaBiLevelWorkUnitPacker
extends KafkaWorkUnitPacker {
    public static final String WORKUNIT_PRE_GROUPING_SIZE_FACTOR = "workunit.pre.grouping.size.factor";
    public static final double DEFAULT_WORKUNIT_PRE_GROUPING_SIZE_FACTOR = 3.0;

    protected KafkaBiLevelWorkUnitPacker(AbstractSource<?, ?> source, SourceState state) {
        super(source, state);
    }

    @Override
    public List<WorkUnit> pack(Map<String, List<WorkUnit>> workUnitsByTopic, int numContainers) {
        double totalEstDataSize = this.setWorkUnitEstSizes(workUnitsByTopic);
        double avgGroupSize = totalEstDataSize / (double)numContainers / KafkaBiLevelWorkUnitPacker.getPreGroupingSizeFactor((State)this.state);
        ArrayList mwuGroups = Lists.newArrayList();
        for (List<WorkUnit> workUnitsForTopic : workUnitsByTopic.values()) {
            double estimatedDataSizeForTopic = KafkaBiLevelWorkUnitPacker.calcTotalEstSizeForTopic(workUnitsForTopic);
            if (estimatedDataSizeForTopic < avgGroupSize) {
                MultiWorkUnit mwuGroup = MultiWorkUnit.createEmpty();
                KafkaBiLevelWorkUnitPacker.addWorkUnitsToMultiWorkUnit(workUnitsForTopic, mwuGroup);
                mwuGroups.add(mwuGroup);
                continue;
            }
            mwuGroups.addAll(KafkaBiLevelWorkUnitPacker.bestFitDecreasingBinPacking(workUnitsForTopic, avgGroupSize));
        }
        List<WorkUnit> groups = this.squeezeMultiWorkUnits(mwuGroups);
        return this.worstFitDecreasingBinPacking(groups, numContainers);
    }

    private static double calcTotalEstSizeForTopic(List<WorkUnit> workUnitsForTopic) {
        double totalSize = 0.0;
        for (WorkUnit w : workUnitsForTopic) {
            totalSize += KafkaBiLevelWorkUnitPacker.getWorkUnitEstSize(w);
        }
        return totalSize;
    }

    private static double getPreGroupingSizeFactor(State state) {
        return state.getPropAsDouble(WORKUNIT_PRE_GROUPING_SIZE_FACTOR, 3.0);
    }

    private static List<MultiWorkUnit> bestFitDecreasingBinPacking(List<WorkUnit> workUnits, double avgGroupSize) {
        Collections.sort(workUnits, LOAD_DESC_COMPARATOR);
        PriorityQueue<MultiWorkUnit> pQueue = new PriorityQueue<MultiWorkUnit>(workUnits.size(), LOAD_DESC_COMPARATOR);
        for (WorkUnit workUnit : workUnits) {
            MultiWorkUnit bestGroup = KafkaBiLevelWorkUnitPacker.findAndPopBestFitGroup(workUnit, pQueue, avgGroupSize);
            if (bestGroup != null) {
                KafkaBiLevelWorkUnitPacker.addWorkUnitToMultiWorkUnit(workUnit, bestGroup);
            } else {
                bestGroup = MultiWorkUnit.createEmpty();
                KafkaBiLevelWorkUnitPacker.addWorkUnitToMultiWorkUnit(workUnit, bestGroup);
            }
            pQueue.add(bestGroup);
        }
        return Lists.newArrayList(pQueue);
    }

    private static MultiWorkUnit findAndPopBestFitGroup(WorkUnit workUnit, PriorityQueue<MultiWorkUnit> pQueue, double avgGroupSize) {
        ArrayList fullWorkUnits = Lists.newArrayList();
        MultiWorkUnit bestFit = null;
        while (!pQueue.isEmpty()) {
            MultiWorkUnit candidate = pQueue.poll();
            if (KafkaBiLevelWorkUnitPacker.getWorkUnitEstSize((WorkUnit)candidate) + KafkaBiLevelWorkUnitPacker.getWorkUnitEstSize(workUnit) <= avgGroupSize) {
                bestFit = candidate;
                break;
            }
            fullWorkUnits.add(candidate);
        }
        for (MultiWorkUnit fullWorkUnit : fullWorkUnits) {
            pQueue.add(fullWorkUnit);
        }
        return bestFit;
    }
}

