/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataComplex;
import com.linkedin.data.DataComplexTable;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.Instrumentable;
import com.linkedin.data.InstrumentationUtil;
import com.linkedin.data.Null;
import com.linkedin.util.ArgumentUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class Data {
    public static final Null NULL = Null.getInstance();
    public static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");

    public static void traverse(Object obj, TraverseCallback callback) throws IOException {
        if (obj == null || obj == NULL) {
            callback.nullValue();
            return;
        }
        Class<?> clas = obj.getClass();
        if (clas == String.class) {
            callback.stringValue((String)obj);
        } else if (clas == Integer.class) {
            callback.integerValue((Integer)obj);
        } else if (clas == DataMap.class) {
            DataMap map = (DataMap)obj;
            if (map.isEmpty()) {
                callback.emptyMap();
            } else {
                callback.startMap(map);
                Iterable<Map.Entry<String, Object>> orderedEntrySet = callback.orderMap(map);
                for (Map.Entry<String, Object> e : orderedEntrySet) {
                    String key = e.getKey();
                    callback.key(key);
                    Data.traverse(e.getValue(), callback);
                }
                callback.endMap();
            }
        } else if (clas == DataList.class) {
            DataList list = (DataList)obj;
            if (list.isEmpty()) {
                callback.emptyList();
            } else {
                callback.startList(list);
                int index = 0;
                for (Object o : list) {
                    callback.index(index);
                    ++index;
                    Data.traverse(o, callback);
                }
                callback.endList();
            }
        } else if (clas == Boolean.class) {
            callback.booleanValue((Boolean)obj);
        } else if (clas == Long.class) {
            callback.longValue((Long)obj);
        } else if (clas == Float.class) {
            callback.floatValue(((Float)obj).floatValue());
        } else if (clas == Double.class) {
            callback.doubleValue((Double)obj);
        } else if (clas == ByteString.class) {
            callback.byteStringValue((ByteString)obj);
        } else {
            callback.illegalValue(obj);
        }
    }

    public static void dump(String name, Object obj, String prefix, StringBuilder builder) {
        try {
            Data.traverse(obj, new DumpTraverseCallback(name, prefix, builder));
        }
        catch (IOException e) {
            builder.append("( Exception: ").append(e).append(" )");
        }
    }

    public static String dump(String name, Object obj, String prefix) {
        StringBuilder builder = new StringBuilder();
        Data.dump(name, obj, prefix, builder);
        return builder.toString();
    }

    public static List<Map.Entry<String, Object>> orderMapEntries(DataMap map) {
        ArrayList<Map.Entry<String, Object>> copy = new ArrayList<Map.Entry<String, Object>>(map.entrySet());
        Collections.sort(copy, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return copy;
    }

    static void checkAllowed(DataComplex parent, Object value) throws IllegalArgumentException {
        ArgumentUtil.notNull(value, "value");
        Class<?> clas = value.getClass();
        if (!Data.isPrimitiveClass(clas)) {
            if (Data.isComplex(value)) {
                if (parent == value || Data.reachable((DataComplex)value, parent)) {
                    throw new IllegalArgumentException("Adding value to Data object will result in a loop");
                }
            } else {
                throw new IllegalArgumentException("Type is not allowed: " + clas);
            }
        }
    }

    private static boolean reachable(DataComplex source, Object destination) {
        Collection<Object> values = source.values();
        for (Object value : values) {
            if (value != destination && (!(value instanceof DataComplex) || !Data.reachable((DataComplex)value, destination))) continue;
            return true;
        }
        return false;
    }

    static boolean isAllowed(Object o) {
        return o != null && (Data.isPrimitive(o) || Data.isComplex(o));
    }

    static boolean isAllowedClass(Class<?> clas) {
        return Data.isPrimitiveClass(clas) || Data.isComplexClass(clas);
    }

    static boolean isPrimitive(Object o) {
        return Data.isPrimitiveClass(o.getClass());
    }

    static boolean isPrimitiveClass(Class<?> clas) {
        return clas == String.class || clas == Integer.class || clas == Double.class || clas == Boolean.class || clas == Long.class || clas == Float.class || clas == ByteString.class || clas == Null.class;
    }

    static boolean isComplex(Object o) {
        return Data.isComplexClass(o.getClass());
    }

    static boolean isComplexClass(Class<?> clas) {
        return clas == DataMap.class || clas == DataList.class;
    }

    static <T> T copy(T object, DataComplexTable alreadyCopied) throws CloneNotSupportedException {
        if (object == null) {
            return null;
        }
        if (Data.isComplex(object)) {
            DataComplex src = (DataComplex)object;
            DataComplex found = alreadyCopied.get(src);
            if (found != null) {
                return (T)found;
            }
            DataComplex clone = src.clone();
            alreadyCopied.put(src, clone);
            if (clone instanceof DataMap) {
                ((DataMap)clone).copyReferencedObjects(alreadyCopied);
            } else if (clone instanceof DataList) {
                ((DataList)clone).copyReferencedObjects(alreadyCopied);
            }
            DataComplex converted = clone;
            return (T)converted;
        }
        if (Data.isPrimitive(object)) {
            return object;
        }
        throw new CloneNotSupportedException("Illegal value encountered: " + object);
    }

    static void makeReadOnly(Object o) {
        if (Data.isComplex(o)) {
            ((DataComplex)o).makeReadOnly();
        }
    }

    public static String bytesToString(byte[] input, int offset, int length) {
        ArgumentUtil.checkBounds(input.length, offset, length);
        char[] charArray = new char[length];
        for (int i = 0; i < length; ++i) {
            charArray[i] = (char)((char)input[i + offset] & 0xFF);
        }
        return new String(charArray);
    }

    public static String bytesToString(byte[] input) {
        return Data.bytesToString(input, 0, input.length);
    }

    public static byte[] stringToBytes(String input, boolean validate) {
        int orChar = 0;
        int length = input.length();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            orChar = (char)(orChar | c);
            bytes[i] = (byte)(c & 0xFF);
        }
        if (validate && (orChar & 0xFF00) != 0) {
            return null;
        }
        return bytes;
    }

    public static boolean validStringAsBytes(String input) {
        int orChar = 0;
        int length = input.length();
        for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            orChar = (char)(orChar | c);
        }
        return (orChar & 0xFF00) == 0;
    }

    static boolean objectIsAcyclic(Object o) {
        return new Object(){
            private IdentityHashMap<DataComplex, Boolean> _visited = new IdentityHashMap();
            private IdentityHashMap<DataComplex, Boolean> _path = new IdentityHashMap();

            boolean objectIsAcyclic(Object object) {
                if (object == null) {
                    return true;
                }
                Class<?> clas = object.getClass();
                if (Data.isPrimitiveClass(clas)) {
                    return true;
                }
                if (Data.isComplex(object)) {
                    DataComplex mutable = (DataComplex)object;
                    Collection<Object> values = mutable.values();
                    Boolean loop = this._path.put(mutable, Boolean.TRUE);
                    if (loop == Boolean.TRUE) {
                        return false;
                    }
                    Boolean visited = this._visited.put(mutable, Boolean.TRUE);
                    if (visited == null) {
                        for (Object value : values) {
                            if (this.objectIsAcyclic(value)) continue;
                            return false;
                        }
                    }
                    this._path.remove(mutable);
                    return true;
                }
                throw new IllegalStateException("Object of unknown type: " + object);
            }
        }.objectIsAcyclic(o);
    }

    public static void appendNames(StringBuilder builder, Collection<Object> names) {
        boolean first = true;
        for (Object name : names) {
            if (name instanceof Integer) {
                builder.append('[').append(name).append(']');
            } else {
                if (!first) {
                    builder.append('.');
                }
                builder.append(name);
            }
            first = false;
        }
    }

    static void startInstrumentingAccess(Collection<Object> c) {
        for (Object o : c) {
            if (!(o instanceof Instrumentable)) continue;
            ((Instrumentable)o).startInstrumentingAccess();
        }
    }

    static void stopInstrumentingAccess(Collection<Object> c) {
        for (Object o : c) {
            if (!(o instanceof Instrumentable)) continue;
            ((Instrumentable)o).stopInstrumentingAccess();
        }
    }

    static void collectInstrumentedData(StringBuilder key, Object object, Integer timesAccessed, Map<String, Map<String, Object>> instrumentedData, boolean collectAllData) {
        if (Data.isComplex(object)) {
            ((DataComplex)object).collectInstrumentedData(key, instrumentedData, collectAllData);
        } else if (collectAllData || timesAccessed > 0) {
            InstrumentationUtil.emitInstrumentationData(key, object, timesAccessed, instrumentedData);
        }
    }

    public static class DumpTraverseCallback
    implements TraverseCallback {
        protected final StringBuilder _builder;
        protected String _prefix;
        protected String _indent = "  ";
        protected String _nameValueSeparator = " : ";
        protected String _listStart = "[";
        protected String _listEnd = "]";
        protected String _mapStart = "{";
        protected String _mapEnd = "}";
        protected String _break = "\n";
        protected String _null = "NULL";

        DumpTraverseCallback(String name, String prefix, StringBuilder builder) {
            this._prefix = prefix;
            this._builder = builder;
            this._builder.append(this._prefix);
            if (name != null && !name.isEmpty()) {
                this._builder.append(name).append(this._nameValueSeparator);
            }
        }

        @Override
        public Iterable<Map.Entry<String, Object>> orderMap(DataMap map) {
            return Data.orderMapEntries(map);
        }

        @Override
        public void nullValue() {
            this._builder.append(this._null).append(this._break);
        }

        @Override
        public void booleanValue(boolean value) {
            this._builder.append(value).append(this._break);
        }

        @Override
        public void integerValue(int value) {
            this._builder.append(value).append(this._break);
        }

        @Override
        public void longValue(long value) {
            this._builder.append(value).append(this._break);
        }

        @Override
        public void floatValue(float value) {
            this._builder.append(value).append(this._break);
        }

        @Override
        public void doubleValue(double value) {
            this._builder.append(value).append(this._break);
        }

        @Override
        public void stringValue(String value) {
            this._builder.append(value).append(this._break);
        }

        @Override
        public void byteStringValue(ByteString value) {
            this._builder.append(value.asAvroString()).append(this._break);
        }

        @Override
        public void illegalValue(Object value) {
            this._builder.append("ILLEGAL VALUE \"").append(value).append("\"");
        }

        @Override
        public void emptyMap() {
            this._builder.append(this._mapStart).append(this._mapEnd).append(this._break);
        }

        @Override
        public void startMap(DataMap map) {
            this._builder.append(this._mapStart).append(this._break);
            this.indent();
        }

        @Override
        public void key(String key) {
            this._builder.append(this._prefix).append(key).append(this._nameValueSeparator);
        }

        @Override
        public void endMap() {
            this.outdent();
            this._builder.append(this._prefix).append(this._mapEnd).append(this._break);
        }

        @Override
        public void emptyList() {
            this._builder.append(this._listStart).append(this._listEnd).append(this._break);
        }

        @Override
        public void startList(DataList list) {
            this._builder.append(this._listStart).append(this._break);
            this.indent();
        }

        @Override
        public void index(int index) {
            this._builder.append(this._prefix);
        }

        @Override
        public void endList() {
            this.outdent();
            this._builder.append(this._prefix).append(this._listEnd).append(this._break);
        }

        protected void indent() {
            if (!this._indent.isEmpty()) {
                this._prefix = this._prefix + this._indent;
            }
        }

        protected void outdent() {
            if (!this._indent.isEmpty()) {
                this._prefix = this._prefix.substring(0, this._prefix.length() - this._indent.length());
            }
        }

        StringBuilder getStringBuilder() {
            return this._builder;
        }
    }

    public static interface TraverseCallback {
        public Iterable<Map.Entry<String, Object>> orderMap(DataMap var1);

        public void nullValue() throws IOException;

        public void booleanValue(boolean var1) throws IOException;

        public void integerValue(int var1) throws IOException;

        public void longValue(long var1) throws IOException;

        public void floatValue(float var1) throws IOException;

        public void doubleValue(double var1) throws IOException;

        public void stringValue(String var1) throws IOException;

        public void byteStringValue(ByteString var1) throws IOException;

        public void illegalValue(Object var1) throws IOException;

        public void emptyMap() throws IOException;

        public void startMap(DataMap var1) throws IOException;

        public void key(String var1) throws IOException;

        public void endMap() throws IOException;

        public void emptyList() throws IOException;

        public void startList(DataList var1) throws IOException;

        public void index(int var1) throws IOException;

        public void endList() throws IOException;
    }
}

