/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PrimitiveDataSchema;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractSchemaEncoder {
    protected TypeReferenceFormat _typeReferenceFormat = TypeReferenceFormat.DENORMALIZE;
    private final Set<String> _alreadyEncountered = new HashSet<String>();

    public AbstractSchemaEncoder() {
    }

    public AbstractSchemaEncoder(TypeReferenceFormat typeReferenceFormat) {
        this._typeReferenceFormat = typeReferenceFormat;
    }

    public abstract void encode(DataSchema var1) throws IOException;

    public TypeReferenceFormat getTypeReferenceFormat() {
        return this._typeReferenceFormat;
    }

    public void setTypeReferenceFormat(TypeReferenceFormat typeReferenceFormat) {
        this._typeReferenceFormat = typeReferenceFormat;
    }

    protected TypeRepresentation selectTypeRepresentation(DataSchema schema, boolean originallyInlined) {
        boolean firstEncounter = true;
        if (schema instanceof NamedDataSchema) {
            String fullName = ((NamedDataSchema)schema).getFullName();
            firstEncounter = !this._alreadyEncountered.contains(fullName);
        } else if (schema instanceof PrimitiveDataSchema) {
            return TypeRepresentation.DECLARED_INLINE;
        }
        switch (this._typeReferenceFormat) {
            case PRESERVE: {
                return originallyInlined ? TypeRepresentation.DECLARED_INLINE : TypeRepresentation.REFERENCED_BY_NAME;
            }
            case DENORMALIZE: {
                return firstEncounter ? TypeRepresentation.DECLARED_INLINE : TypeRepresentation.REFERENCED_BY_NAME;
            }
            case MINIMIZE: {
                return TypeRepresentation.REFERENCED_BY_NAME;
            }
        }
        throw new IllegalArgumentException("Unrecognized enum symbol: " + (Object)((Object)this._typeReferenceFormat));
    }

    public void markEncountered(DataSchema schema) {
        if (schema instanceof NamedDataSchema) {
            this._alreadyEncountered.add(((NamedDataSchema)schema).getFullName());
        }
    }

    protected static enum TypeRepresentation {
        DECLARED_INLINE,
        REFERENCED_BY_NAME;

    }

    public static enum TypeReferenceFormat {
        DENORMALIZE,
        PRESERVE,
        MINIMIZE;

    }
}

