/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaConstants;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.NamedDataSchema;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class EnumDataSchema
extends NamedDataSchema {
    private List<String> _symbols = _emptySymbols;
    private Map<String, Integer> _symbolToIndexMap = _emptySymbolToIndexMap;
    private Map<String, String> _symbolToDocMap = _emptySymbolToDocMap;
    private static final List<String> _emptySymbols = Collections.emptyList();
    private static final Map<String, Integer> _emptySymbolToIndexMap = Collections.emptyMap();
    private static final Map<String, String> _emptySymbolToDocMap = Collections.emptyMap();

    public EnumDataSchema(Name name) {
        super(DataSchema.Type.ENUM, name);
    }

    public boolean setSymbols(List<String> symbols, StringBuilder errorMessageBuilder) {
        boolean ok = true;
        if (symbols != null) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            int index = 0;
            for (String symbol : symbols) {
                if (!EnumDataSchema.isValidEnumSymbol(symbol)) {
                    errorMessageBuilder.append("\"").append(symbol).append("\" is an invalid enum symbol.\n");
                    ok = false;
                    this.setHasError();
                }
                if (map.containsKey(symbol)) {
                    errorMessageBuilder.append("\"").append(symbol).append(" \" defined more than once in enum symbols.\n");
                    ok = false;
                } else {
                    map.put(symbol, index);
                }
                ++index;
            }
            this._symbols = Collections.unmodifiableList(symbols);
            this._symbolToIndexMap = Collections.unmodifiableMap(map);
        }
        if (!ok) {
            this.setHasError();
        }
        return ok;
    }

    public boolean setSymbolDocs(Map<String, Object> symbolDocs, StringBuilder errorMessageBuilder) {
        boolean ok = true;
        if (symbolDocs != null) {
            LinkedHashMap<String, String> symbolDocsMap = new LinkedHashMap<String, String>();
            for (String string : this._symbols) {
                if (!symbolDocs.containsKey(string)) continue;
                Object value = symbolDocs.get(string);
                if (value instanceof String) {
                    String replaced = symbolDocsMap.put(string, (String)value);
                    assert (replaced == null);
                    continue;
                }
                ok = false;
                errorMessageBuilder.append("\"").append(string).append("\" symbol has an invalid documentation value. All symbol documentation values must be strings.\n");
            }
            if (ok) {
                for (Map.Entry entry : symbolDocs.entrySet()) {
                    String symbol = (String)entry.getKey();
                    if (symbolDocsMap.containsKey(symbol)) continue;
                    ok = false;
                    errorMessageBuilder.append("\"").append(symbol).append("\" symbol is referenced by the symbol documentation. This symbol does not exist.\n");
                }
            }
            this._symbolToDocMap = Collections.unmodifiableMap(symbolDocsMap);
        }
        if (!ok) {
            this.setHasError();
        }
        return ok;
    }

    public List<String> getSymbols() {
        return this._symbols;
    }

    public Map<String, String> getSymbolDocs() {
        return this._symbolToDocMap;
    }

    public int index(String symbol) {
        Integer res = this._symbolToIndexMap.get(symbol);
        return res == null ? -1 : res;
    }

    public boolean contains(String symbol) {
        return this._symbolToIndexMap.containsKey(symbol);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object.getClass() == EnumDataSchema.class) {
            EnumDataSchema other = (EnumDataSchema)object;
            return super.equals(other) && this._symbols.equals(other._symbols) && this._symbolToDocMap.equals(other._symbolToDocMap);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this._symbols.hashCode() ^ this._symbolToDocMap.hashCode();
    }

    public static boolean isValidEnumSymbol(String symbol) {
        return DataSchemaConstants.ENUM_SYMBOL_PATTERN.matcher(symbol).matches();
    }
}

