/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.schema.BindingInfo;
import com.linkedin.data.schema.ComplexDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.Named;
import java.util.Collections;
import java.util.List;

public abstract class NamedDataSchema
extends ComplexDataSchema
implements Named,
BindingInfo {
    private final Name _name;
    private String _package = "";
    private String _doc = "";
    private List<Name> _aliases = _emptyAliases;
    private static final List<Name> _emptyAliases = Collections.emptyList();

    protected NamedDataSchema(DataSchema.Type type, Name name) {
        super(type);
        this._name = name;
    }

    public void setAliases(List<Name> aliases) {
        this._aliases = Collections.unmodifiableList(aliases);
    }

    public void setDoc(String documentation) {
        this._doc = documentation;
    }

    public void setPackage(String packageName) {
        this._package = packageName;
    }

    @Override
    public String getName() {
        return this._name.getName();
    }

    @Override
    public String getFullName() {
        return this._name.getFullName();
    }

    @Override
    public String getBindingName() {
        return this._package == null || this._package.isEmpty() ? this.getFullName() : this._package + "." + this.getName();
    }

    @Override
    public String getPackage() {
        return this._package;
    }

    @Override
    public String getNamespace() {
        return this._name.getNamespace();
    }

    public List<Name> getAliases() {
        return this._aliases;
    }

    public String getDoc() {
        return this._doc;
    }

    @Override
    public String getUnionMemberKey() {
        return this.getFullName();
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object instanceof NamedDataSchema) {
            NamedDataSchema other = (NamedDataSchema)object;
            return super.equals(object) && this._name.equals(other._name) && this._doc.equals(other._doc) && this._aliases.equals(other._aliases);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this._name.hashCode() ^ this._doc.hashCode() ^ this._aliases.hashCode();
    }
}

