/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.validator;

import com.linkedin.data.DataMap;
import com.linkedin.data.element.DataElement;
import com.linkedin.data.message.Message;
import com.linkedin.data.schema.validator.AbstractValidator;
import com.linkedin.data.schema.validator.ValidatorContext;

public class StrlenValidator
extends AbstractValidator {
    public static final String MIN = "min";
    public static final String MAX = "max";
    private final int _min;
    private final int _max;

    public StrlenValidator(DataMap config) {
        super(config);
        Integer min = config.getInteger(MIN);
        Integer max = config.getInteger(MAX);
        this._min = min == null ? 0 : min;
        this._max = max == null ? Integer.MAX_VALUE : max;
    }

    @Override
    public void validate(ValidatorContext ctx) {
        DataElement element = ctx.dataElement();
        Object value = element.getValue();
        String str = String.valueOf(value);
        int strlen = str.length();
        if (strlen < this._min || strlen > this._max) {
            ctx.addResult(new Message(element.path(), "length of \"%1$s\" is out of range %2$d...%3$d", str, this._min, this._max));
        }
    }
}

