/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.template.AbstractMapTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.util.ArgumentUtil;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class DirectMapTemplate<V>
extends AbstractMapTemplate<V> {
    protected final EntrySet _entrySet = new EntrySet();

    protected DirectMapTemplate(DataMap map, MapDataSchema schema, Class<V> valueClass) {
        this(map, schema, valueClass, valueClass.isEnum() ? String.class : valueClass);
    }

    protected DirectMapTemplate(DataMap map, MapDataSchema schema, Class<V> valueClass, Class<?> dataClass) {
        super(map, schema, valueClass, dataClass);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value != null && this._valueClass != this._dataClass && value.getClass() == this._valueClass) {
            try {
                Object v = value;
                value = this.coerceInput(v);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return this._map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this._entrySet;
    }

    @Override
    public V get(Object key) throws TemplateOutputCastException {
        return this.coerceOutput(this._map.get(key));
    }

    @Override
    public V put(String key, V value) throws ClassCastException, TemplateOutputCastException {
        return this.coerceOutput(this._map.put(key, this.coerceInput(value)));
    }

    @Override
    public V remove(Object key) throws TemplateOutputCastException {
        return this.coerceOutput(this._map.remove(key));
    }

    protected Object coerceInput(V object) throws ClassCastException {
        ArgumentUtil.notNull(object, "object");
        return DataTemplateUtil.coerceInput(object, this._valueClass, this._dataClass);
    }

    protected V coerceOutput(Object object) throws TemplateOutputCastException {
        if (object == null) {
            return null;
        }
        return (V)DataTemplateUtil.coerceOutput(object, this._valueClass);
    }

    protected class EntrySet
    extends AbstractMapTemplate.AbstractEntrySet {
        protected EntrySet() {
        }

        @Override
        public boolean add(Map.Entry<String, V> entry) throws ClassCastException {
            DirectMapTemplate.this.coerceInput(entry.getValue());
            return DirectMapTemplate.this._map.entrySet().add(entry);
        }

        @Override
        public boolean contains(Object object) {
            Class<?> valueClass;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object key = entry.getKey();
            if (key == null || key.getClass() != String.class) {
                return false;
            }
            Object value = entry.getValue();
            if (value == null || (valueClass = value.getClass()) != DirectMapTemplate.this._valueClass) {
                return false;
            }
            if (valueClass.isEnum()) {
                return DirectMapTemplate.this._map.entrySet().contains(new AbstractMap.SimpleImmutableEntry<String, String>((String)key, value.toString()));
            }
            return DirectMapTemplate.this._map.entrySet().contains(object);
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            final Iterator it = DirectMapTemplate.this._map.entrySet().iterator();
            return new Iterator<Map.Entry<String, V>>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Map.Entry<String, V> next() {
                    Map.Entry entry = (Map.Entry)it.next();
                    Object value = entry.getValue();
                    if (value.getClass() != DirectMapTemplate.this._valueClass) {
                        return new AbstractMapTemplate.WrappingMapEntry<V>(entry){

                            @Override
                            public V getValue() throws TemplateOutputCastException {
                                if (this._value == null) {
                                    this._value = DirectMapTemplate.this.coerceOutput(this._entry.getValue());
                                }
                                return this._value;
                            }

                            @Override
                            public V setValue(V value) throws ClassCastException, TemplateOutputCastException {
                                Object ret = DirectMapTemplate.this.coerceOutput(this._entry.setValue(DirectMapTemplate.this.coerceInput(value)));
                                this._value = null;
                                return ret;
                            }
                        };
                    }
                    return entry;
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }

        @Override
        public boolean remove(Object entry) {
            return DirectMapTemplate.this._map.entrySet().remove(entry);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return DirectMapTemplate.this._map.entrySet().removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return DirectMapTemplate.this._map.entrySet().retainAll(c);
        }
    }
}

