/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger _log = LoggerFactory.getLogger(FileUtil.class);

    public static List<File> listFiles(File directory, FileFilter fileFilter) {
        ArrayList<File> result = new ArrayList<File>();
        ArrayDeque<File> deque = new ArrayDeque<File>();
        deque.addFirst(directory);
        while (!deque.isEmpty()) {
            File file = (File)deque.removeFirst();
            if (file.isDirectory()) {
                File[] filesInDirectory = file.listFiles();
                if (filesInDirectory == null) {
                    _log.error("Unable to list files under " + file.getPath());
                    continue;
                }
                for (File f : filesInDirectory) {
                    deque.addLast(f);
                }
                continue;
            }
            if (fileFilter != null && !fileFilter.accept(file)) continue;
            result.add(file);
        }
        return result;
    }

    public static String buildSystemIndependentPath(String ... pathPieces) {
        char separtor = File.separatorChar;
        StringBuilder sb = new StringBuilder();
        for (String piece : pathPieces) {
            sb.append(separtor);
            sb.append(piece);
        }
        return sb.toString();
    }

    public static String removeFileExtension(String filename) {
        int idx = filename.lastIndexOf(46);
        if (idx == 0) {
            return filename;
        }
        return filename.substring(0, idx);
    }

    public static boolean upToDate(Collection<File> sourceFiles, Collection<File> targetFiles) {
        long sourceLastModified = FileUtil.mostRecentLastModified(sourceFiles);
        return FileUtil.filesLastModifiedMoreRecentThan(targetFiles, sourceLastModified);
    }

    private static long mostRecentLastModified(Collection<File> files) {
        long mostRecent = 0L;
        for (File file : files) {
            long fileLastModified = file.lastModified();
            if (mostRecent >= fileLastModified) continue;
            mostRecent = fileLastModified;
        }
        return mostRecent;
    }

    public static String getExtension(File file) {
        String extension = "";
        String fileName = file.getName();
        int i = fileName.lastIndexOf(46);
        if (i > 0) {
            extension = fileName.substring(i + 1);
        }
        return extension;
    }

    private static boolean filesLastModifiedMoreRecentThan(Collection<File> files, long time) {
        for (File file : files) {
            if (file.exists() && time < file.lastModified()) continue;
            return false;
        }
        return true;
    }

    public static class FileExtensionFilter
    implements FileFilter {
        private final String[] _extensions;

        public FileExtensionFilter(String extension) {
            this._extensions = new String[]{extension};
        }

        public FileExtensionFilter(String[] extensions) {
            this._extensions = extensions;
        }

        @Override
        public boolean accept(File file) {
            for (String extension : this._extensions) {
                if (!file.getName().endsWith(extension)) continue;
                return true;
            }
            return false;
        }
    }
}

