/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.r2.transport.common.bridge.common.RequestWithCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import com.linkedin.r2.transport.http.client.Http2StreamCodec;
import com.linkedin.r2.transport.http.client.TimeoutAsyncPoolHandle;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.internal.ObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Http2AlpnHandler
extends ChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Http2AlpnHandler.class);
    private final SslHandler _sslHandler;
    private final Http2StreamCodec _http2Handler;
    private ChannelPromise _alpnPromise;

    public Http2AlpnHandler(SslHandler sslHandler, Http2StreamCodec http2Handler) {
        ObjectUtil.checkNotNull((Object)sslHandler, (String)"sslHandler");
        ObjectUtil.checkNotNull((Object)((Object)http2Handler), (String)"http2Handler");
        this._sslHandler = sslHandler;
        this._http2Handler = http2Handler;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this._alpnPromise = ctx.channel().newPromise();
        ctx.pipeline().addFirst("sslHandler", (ChannelHandler)this._sslHandler);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof RequestWithCallback)) {
            ctx.write(msg, promise);
            return;
        }
        this._alpnPromise.addListener(f -> {
            ChannelFuture future = (ChannelFuture)f;
            if (future.isSuccess()) {
                ctx.write(msg, promise);
            } else {
                TimeoutAsyncPoolHandle handle = (TimeoutAsyncPoolHandle)((RequestWithCallback)msg).handle();
                handle.error().release();
                TransportCallback callback = ((RequestWithCallback)msg).callback();
                callback.onResponse(TransportResponseImpl.error((Throwable)future.cause()));
            }
        });
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        this._alpnPromise.addListener(f -> {
            ChannelFuture future = (ChannelFuture)f;
            if (future.isSuccess()) {
                ctx.flush();
            }
        });
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
            if (handshakeEvent.isSuccess()) {
                LOG.debug("SSL handshake succeeded");
                SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
                if (sslHandler == null) {
                    ctx.fireExceptionCaught((Throwable)new IllegalStateException("cannot find a SslHandler in the pipeline (required for application-level protocol negotiation)"));
                    return;
                }
                String protocol = sslHandler.applicationProtocol();
                if ("h2".equals(protocol)) {
                    LOG.debug("HTTP/2 is negotiated");
                    ctx.pipeline().addAfter("sslHandler", "http2Handler", (ChannelHandler)this._http2Handler);
                    ctx.pipeline().remove((ChannelHandler)this);
                    this._alpnPromise.setSuccess();
                } else {
                    LOG.error("Protocol {}, instead of HTTP/2, is negotiated through ALPN", (Object)protocol);
                    this._alpnPromise.setFailure((Throwable)new IllegalStateException("HTTP/2 ALPN negotiation failed"));
                }
            } else {
                LOG.error("SSL handshake failed", handshakeEvent.cause());
                this._alpnPromise.setFailure(handshakeEvent.cause());
            }
        }
        ctx.fireUserEventTriggered(evt);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error("Application level protocol negotiation failed", cause);
        this._alpnPromise.setFailure(cause);
        ctx.fireExceptionCaught(cause);
    }
}

