/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.r2.message.Request;
import com.linkedin.r2.transport.common.bridge.common.RequestWithCallback;
import com.linkedin.r2.transport.http.client.Http2AlpnHandler;
import com.linkedin.r2.transport.http.client.Http2ChannelPoolHandler;
import com.linkedin.r2.transport.http.client.Http2SchemeHandler;
import com.linkedin.r2.transport.http.client.Http2StreamCodec;
import com.linkedin.r2.transport.http.client.Http2StreamCodecBuilder;
import com.linkedin.r2.transport.http.client.Http2StreamResponseHandler;
import com.linkedin.r2.transport.http.client.Http2UpgradeHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslHandler;
import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

class Http2InitializerHandler
extends ChannelOutboundHandlerAdapter {
    private static final int MAX_CLIENT_UPGRADE_CONTENT_LENGTH = Integer.MAX_VALUE;
    private static final int MAX_INITIAL_LINE_LENGTH = 4096;
    private static final boolean IS_CLIENT = true;
    private final int _maxHeaderSize;
    private final int _maxChunkSize;
    private final long _maxResponseSize;
    private final long _streamingTimeout;
    private final long _gracefulShutdownTimeout;
    private final Http2Connection _connection;
    private final ScheduledExecutorService _scheduler;
    private final SSLContext _sslContext;
    private final SSLParameters _sslParameters;
    private boolean _setupComplete = false;

    public Http2InitializerHandler(int maxHeaderSize, int maxChunkSize, long maxResponseSize, long streamingTimeout, ScheduledExecutorService scheduler, Http2Connection connection, SSLContext sslContext, SSLParameters sslParameters) {
        this._maxHeaderSize = maxHeaderSize;
        this._maxChunkSize = maxChunkSize;
        this._maxResponseSize = maxResponseSize;
        this._streamingTimeout = streamingTimeout;
        this._gracefulShutdownTimeout = streamingTimeout;
        this._scheduler = scheduler;
        this._connection = connection;
        this._sslContext = sslContext;
        this._sslParameters = sslParameters;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof RequestWithCallback)) {
            ctx.write(msg, promise);
            return;
        }
        if (this._setupComplete) {
            ctx.write(msg);
        } else {
            Request request = ((RequestWithCallback)msg).request();
            URI uri = request.getURI();
            String scheme = uri.getScheme();
            if (scheme.equalsIgnoreCase(HttpScheme.HTTPS.toString())) {
                this.configureHttpsPipeline(ctx);
            } else if (scheme.equalsIgnoreCase(HttpScheme.HTTP.toString())) {
                this.configureHttpPipeline(ctx, request);
            } else {
                throw new IllegalArgumentException("Invalid scheme " + scheme + ", expected either http or https");
            }
            ctx.write(msg);
        }
    }

    private void configureHttpPipeline(ChannelHandlerContext ctx, Request request) throws Exception {
        Http2StreamCodec http2Codec = new Http2StreamCodecBuilder().connection(this._connection).maxContentLength(this._maxResponseSize).maxHeaderSize(this._maxHeaderSize).gracefulShutdownTimeoutMillis(this._gracefulShutdownTimeout).streamingTimeout(this._streamingTimeout).scheduler(this._scheduler).build();
        HttpClientCodec sourceCodec = new HttpClientCodec(4096, this._maxHeaderSize, this._maxChunkSize);
        Http2ClientUpgradeCodec targetCodec = new Http2ClientUpgradeCodec((Http2ConnectionHandler)http2Codec);
        HttpClientUpgradeHandler upgradeCodec = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)targetCodec, Integer.MAX_VALUE);
        Http2SchemeHandler schemeHandler = new Http2SchemeHandler(HttpScheme.HTTP.toString());
        String host = request.getURI().getAuthority();
        int port = request.getURI().getPort();
        String path = request.getURI().getPath();
        Http2UpgradeHandler upgradeHandler = new Http2UpgradeHandler(host, port, path);
        Http2StreamResponseHandler responseHandler = new Http2StreamResponseHandler();
        Http2ChannelPoolHandler channelPoolHandler = new Http2ChannelPoolHandler();
        ctx.pipeline().addBefore(ctx.name(), "sourceCodec", (ChannelHandler)sourceCodec);
        ctx.pipeline().addBefore(ctx.name(), "upgradeCodec", (ChannelHandler)upgradeCodec);
        ctx.pipeline().addBefore(ctx.name(), "upgradeHandler", (ChannelHandler)upgradeHandler);
        ctx.pipeline().addBefore(ctx.name(), "schemeHandler", (ChannelHandler)schemeHandler);
        ctx.pipeline().addBefore(ctx.name(), "responseHandler", (ChannelHandler)responseHandler);
        ctx.pipeline().addBefore(ctx.name(), "channelHandler", (ChannelHandler)channelPoolHandler);
        this._setupComplete = true;
    }

    private void configureHttpsPipeline(ChannelHandlerContext ctx) throws Exception {
        JdkSslContext context = new JdkSslContext(this._sslContext, true, Arrays.asList(this._sslParameters.getCipherSuites()), (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}), this._sslParameters.getNeedClientAuth() ? ClientAuth.REQUIRE : ClientAuth.OPTIONAL);
        SslHandler sslHandler = context.newHandler(ctx.alloc());
        Http2StreamCodec http2Codec = new Http2StreamCodecBuilder().connection(this._connection).maxContentLength(this._maxResponseSize).maxHeaderSize(this._maxHeaderSize).gracefulShutdownTimeoutMillis(this._gracefulShutdownTimeout).streamingTimeout(this._streamingTimeout).scheduler(this._scheduler).build();
        Http2AlpnHandler alpnHandler = new Http2AlpnHandler(sslHandler, http2Codec);
        Http2SchemeHandler schemeHandler = new Http2SchemeHandler(HttpScheme.HTTPS.toString());
        Http2StreamResponseHandler responseHandler = new Http2StreamResponseHandler();
        Http2ChannelPoolHandler channelPoolHandler = new Http2ChannelPoolHandler();
        ctx.pipeline().addBefore(ctx.name(), "alpnHandler", (ChannelHandler)alpnHandler);
        ctx.pipeline().addBefore(ctx.name(), "schemeHandler", (ChannelHandler)schemeHandler);
        ctx.pipeline().addBefore(ctx.name(), "responseHandler", (ChannelHandler)responseHandler);
        ctx.pipeline().addBefore(ctx.name(), "channelHandler", (ChannelHandler)channelPoolHandler);
        this._setupComplete = true;
    }
}

