/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.r2.message.Response;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.message.stream.StreamResponseBuilder;
import com.linkedin.r2.transport.common.WireAttributeHelper;
import com.linkedin.r2.transport.common.bridge.common.ResponseWithCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
class Http2StreamResponseHandler
extends ChannelInboundHandlerAdapter {
    private static Logger LOG = LoggerFactory.getLogger(Http2StreamResponseHandler.class);

    Http2StreamResponseHandler() {
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ResponseWithCallback) {
            ResponseWithCallback responseWithCallback = (ResponseWithCallback)msg;
            StreamResponse response = (StreamResponse)responseWithCallback.response();
            TransportCallback callback = responseWithCallback.callback();
            HashMap headers = new HashMap(response.getHeaders());
            HashMap wireAttrs = new HashMap(WireAttributeHelper.removeWireAttributes(headers));
            StreamResponse newResponse = ((StreamResponseBuilder)new StreamResponseBuilder((Response)response).unsafeSetHeaders(headers)).build(response.getEntityStream());
            LOG.debug("{}: handling a response", (Object)ctx.channel().remoteAddress());
            callback.onResponse(TransportResponseImpl.success((Object)newResponse, wireAttrs));
        }
        ctx.fireChannelRead(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error("Pipeline encountered an unexpected exception", cause);
    }
}

