/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.MultiCallback;
import com.linkedin.common.util.None;
import com.linkedin.r2.disruptor.DisruptFilter;
import com.linkedin.r2.filter.CompressionConfig;
import com.linkedin.r2.filter.FilterChain;
import com.linkedin.r2.filter.FilterChains;
import com.linkedin.r2.filter.compression.ClientCompressionFilter;
import com.linkedin.r2.filter.compression.ClientStreamCompressionFilter;
import com.linkedin.r2.filter.compression.EncodingType;
import com.linkedin.r2.filter.compression.streaming.StreamEncodingType;
import com.linkedin.r2.filter.message.rest.RestFilter;
import com.linkedin.r2.filter.message.stream.StreamFilter;
import com.linkedin.r2.filter.transport.ClientQueryTunnelFilter;
import com.linkedin.r2.filter.transport.FilterChainClient;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.TransportClientFactory;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.http.client.AbstractJmxManager;
import com.linkedin.r2.transport.http.client.AbstractNettyStreamClient;
import com.linkedin.r2.transport.http.client.AsyncPoolImpl;
import com.linkedin.r2.transport.http.client.Http2NettyStreamClient;
import com.linkedin.r2.transport.http.client.HttpNettyClient;
import com.linkedin.r2.transport.http.client.HttpNettyStreamClient;
import com.linkedin.r2.transport.http.common.HttpProtocolVersion;
import com.linkedin.r2.util.ConfigValueExtractor;
import com.linkedin.r2.util.NamedThreadFactory;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientFactory
implements TransportClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientFactory.class);
    public static final String HTTP_QUERY_POST_THRESHOLD = "http.queryPostThreshold";
    public static final String HTTP_REQUEST_TIMEOUT = "http.requestTimeout";
    public static final String HTTP_MAX_RESPONSE_SIZE = "http.maxResponseSize";
    public static final String HTTP_POOL_SIZE = "http.poolSize";
    public static final String HTTP_POOL_WAITER_SIZE = "http.poolWaiterSize";
    public static final String HTTP_IDLE_TIMEOUT = "http.idleTimeout";
    public static final String HTTP_SHUTDOWN_TIMEOUT = "http.shutdownTimeout";
    public static final String HTTP_SSL_CONTEXT = "http.sslContext";
    public static final String HTTP_SSL_PARAMS = "http.sslParams";
    public static final String HTTP_RESPONSE_COMPRESSION_OPERATIONS = "http.responseCompressionOperations";
    public static final String HTTP_RESPONSE_CONTENT_ENCODINGS = "http.responseContentEncodings";
    public static final String HTTP_REQUEST_CONTENT_ENCODINGS = "http.requestContentEncodings";
    public static final String HTTP_USE_RESPONSE_COMPRESSION = "http.useResponseCompression";
    public static final String HTTP_SERVICE_NAME = "http.serviceName";
    public static final String HTTP_POOL_STRATEGY = "http.poolStrategy";
    public static final String HTTP_POOL_MIN_SIZE = "http.poolMinSize";
    public static final String HTTP_MAX_HEADER_SIZE = "http.maxHeaderSize";
    public static final String HTTP_MAX_CHUNK_SIZE = "http.maxChunkSize";
    public static final String HTTP_MAX_CONCURRENT_CONNECTIONS = "http.maxConcurrentConnections";
    public static final String HTTP_PROTOCOL_VERSION = "http.protocolVersion";
    public static final int DEFAULT_POOL_WAITER_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_POOL_SIZE = 200;
    public static final int DEFAULT_REQUEST_TIMEOUT = 10000;
    public static final int DEFAULT_IDLE_TIMEOUT = 25000;
    public static final int DEFAULT_SHUTDOWN_TIMEOUT = 5000;
    public static final long DEFAULT_MAX_RESPONSE_SIZE = 0x200000L;
    public static final String DEFAULT_CLIENT_NAME = "noNameSpecifiedClient";
    public static final AsyncPoolImpl.Strategy DEFAULT_POOL_STRATEGY = AsyncPoolImpl.Strategy.MRU;
    public static final int DEFAULT_POOL_MIN_SIZE = 0;
    public static final int DEFAULT_MAX_HEADER_SIZE = 8192;
    public static final int DEFAULT_MAX_CHUNK_SIZE = 8192;
    public static final EncodingType[] DEFAULT_RESPONSE_CONTENT_ENCODINGS = new EncodingType[]{EncodingType.GZIP, EncodingType.SNAPPY, EncodingType.SNAPPY_FRAMED, EncodingType.DEFLATE, EncodingType.BZIP2};
    public static final StreamEncodingType[] DEFAULT_STREAM_RESPONSE_CONTENT_ENCODINGS = new StreamEncodingType[]{StreamEncodingType.GZIP, StreamEncodingType.SNAPPY_FRAMED, StreamEncodingType.DEFLATE, StreamEncodingType.BZIP2};
    private static final String LIST_SEPARATOR = ",";
    private final NioEventLoopGroup _eventLoopGroup;
    private final ScheduledExecutorService _executor;
    private final ExecutorService _callbackExecutorGroup;
    private final boolean _shutdownFactory;
    private final boolean _shutdownExecutor;
    private final boolean _shutdownCallbackExecutor;
    private final FilterChain _filters;
    private final Executor _compressionExecutor;
    private final AtomicBoolean _finishingShutdown = new AtomicBoolean(false);
    private volatile ScheduledFuture<?> _shutdownTimeoutTask;
    private final AbstractJmxManager _jmxManager;
    private final CompressionConfig _defaultRequestCompressionConfig;
    private final Map<String, CompressionConfig> _requestCompressionConfigs;
    private final Map<String, CompressionConfig> _responseCompressionConfigs;
    private final boolean _useClientCompression;
    private final boolean _tcpNoDelay;
    private final HttpProtocolVersion _defaultHttpVersion;
    private final Object _mutex = new Object();
    private boolean _running = true;
    private int _clientsOutstanding = 0;
    private Callback<None> _factoryShutdownCallback;

    public HttpClientFactory() {
        this(FilterChains.empty());
    }

    public HttpClientFactory(ExecutorService callbackExecutor, boolean shutdownCallbackExecutor) {
        this(FilterChains.empty(), new NioEventLoopGroup(0, (ThreadFactory)new NamedThreadFactory("R2 Nio Event Loop")), true, Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("R2 Netty Scheduler")), true, callbackExecutor, shutdownCallbackExecutor);
    }

    public HttpClientFactory(FilterChain filters) {
        this(filters, new NioEventLoopGroup(0, (ThreadFactory)new NamedThreadFactory("R2 Nio Event Loop")), true, Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("R2 Netty Scheduler")), true);
    }

    public HttpClientFactory(FilterChain filters, NioEventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, null, false);
    }

    public HttpClientFactory(FilterChain filters, NioEventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, AbstractJmxManager.NULL_JMX_MANAGER);
    }

    public HttpClientFactory(FilterChain filters, NioEventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, jmxManager, true);
    }

    public HttpClientFactory(FilterChain filters, NioEventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager, int requestCompressionThresholdDefault, Map<String, CompressionConfig> requestCompressionConfigs) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, jmxManager, requestCompressionThresholdDefault, requestCompressionConfigs, true);
    }

    public HttpClientFactory(FilterChain filters, NioEventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager, int requestCompressionThresholdDefault, Map<String, CompressionConfig> requestCompressionConfigs, boolean useClientCompression) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, jmxManager, requestCompressionThresholdDefault, requestCompressionConfigs, Collections.emptyMap(), useClientCompression);
    }

    public HttpClientFactory(FilterChain filters, NioEventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager, int requestCompressionThresholdDefault, Map<String, CompressionConfig> requestCompressionConfigs, Map<String, CompressionConfig> responseCompressionConfigs, boolean useClientCompression) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, jmxManager, requestCompressionThresholdDefault, requestCompressionConfigs, responseCompressionConfigs, false, useClientCompression ? Executors.newCachedThreadPool() : null, HttpProtocolVersion.HTTP_1_1);
    }

    public HttpClientFactory(FilterChain filters, NioEventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager, boolean tcpNoDelay) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, jmxManager, tcpNoDelay, Integer.MAX_VALUE, Collections.emptyMap(), Executors.newCachedThreadPool());
    }

    public HttpClientFactory(FilterChain filters, NioEventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager, boolean tcpNoDelay, int requestCompressionThresholdDefault, Map<String, CompressionConfig> requestCompressionConfigs, Executor compressionExecutor) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, jmxManager, requestCompressionThresholdDefault, requestCompressionConfigs, Collections.emptyMap(), tcpNoDelay, compressionExecutor, HttpProtocolVersion.HTTP_1_1);
    }

    public HttpClientFactory(FilterChain filters, NioEventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager, int requestCompressionThresholdDefault, Map<String, CompressionConfig> requestCompressionConfigs, Map<String, CompressionConfig> responseCompressionConfigs, boolean tcpNoDelay, Executor compressionExecutor) {
        this(filters, eventLoopGroup, shutdownFactory, executor, shutdownExecutor, callbackExecutorGroup, shutdownCallbackExecutor, jmxManager, requestCompressionThresholdDefault, requestCompressionConfigs, responseCompressionConfigs, tcpNoDelay, compressionExecutor, HttpProtocolVersion.HTTP_1_1);
    }

    public HttpClientFactory(FilterChain filters, NioEventLoopGroup eventLoopGroup, boolean shutdownFactory, ScheduledExecutorService executor, boolean shutdownExecutor, ExecutorService callbackExecutorGroup, boolean shutdownCallbackExecutor, AbstractJmxManager jmxManager, int requestCompressionThresholdDefault, Map<String, CompressionConfig> requestCompressionConfigs, Map<String, CompressionConfig> responseCompressionConfigs, boolean tcpNoDelay, Executor compressionExecutor, HttpProtocolVersion defaultHttpVersion) {
        this._filters = filters;
        this._eventLoopGroup = eventLoopGroup;
        this._shutdownFactory = shutdownFactory;
        this._executor = executor;
        this._shutdownExecutor = shutdownExecutor;
        this._callbackExecutorGroup = callbackExecutorGroup;
        this._shutdownCallbackExecutor = shutdownCallbackExecutor;
        this._jmxManager = jmxManager;
        this._defaultRequestCompressionConfig = new CompressionConfig(requestCompressionThresholdDefault);
        if (requestCompressionConfigs == null) {
            throw new IllegalArgumentException("requestCompressionConfigs should not be null.");
        }
        this._requestCompressionConfigs = Collections.unmodifiableMap(requestCompressionConfigs);
        if (responseCompressionConfigs == null) {
            throw new IllegalArgumentException("responseCompressionConfigs should not be null.");
        }
        this._responseCompressionConfigs = Collections.unmodifiableMap(responseCompressionConfigs);
        this._tcpNoDelay = tcpNoDelay;
        this._compressionExecutor = compressionExecutor;
        this._useClientCompression = this._compressionExecutor != null;
        this._defaultHttpVersion = defaultHttpVersion;
    }

    public TransportClient getClient(Map<String, ? extends Object> properties) {
        properties = new HashMap<String, Object>(properties);
        SSLContext sslContext = HttpClientFactory.coerceAndRemoveFromMap(HTTP_SSL_CONTEXT, properties, SSLContext.class);
        SSLParameters sslParameters = HttpClientFactory.coerceAndRemoveFromMap(HTTP_SSL_PARAMS, properties, SSLParameters.class);
        return this.getClient(properties, sslContext, sslParameters);
    }

    TransportClient getRawClient(Map<String, String> properties) {
        return this.getRawClient(properties, null, null);
    }

    private static <T> T coerceAndRemoveFromMap(String key, Map<String, ?> props, Class<T> valueClass) {
        return HttpClientFactory.coerce(key, props.remove(key), valueClass);
    }

    private static <T> T coerce(String key, Object value, Class<T> valueClass) {
        if (value == null) {
            return null;
        }
        if (!valueClass.isInstance(value)) {
            throw new IllegalArgumentException("Property " + key + " is of type " + value.getClass().getName() + " but must be " + valueClass.getName());
        }
        return valueClass.cast(value);
    }

    CompressionConfig getRestRequestCompressionConfig(String httpServiceName, EncodingType requestContentEncoding) {
        if (this._requestCompressionConfigs.containsKey(httpServiceName)) {
            if (requestContentEncoding == EncodingType.IDENTITY) {
                LOG.warn("No request compression algorithm available but compression config specified for service {}", (Object)httpServiceName);
            }
            return this._requestCompressionConfigs.get(httpServiceName);
        }
        return this._defaultRequestCompressionConfig;
    }

    CompressionConfig getStreamRequestCompressionConfig(String httpServiceName, StreamEncodingType requestContentEncoding) {
        if (this._requestCompressionConfigs.containsKey(httpServiceName)) {
            if (requestContentEncoding == StreamEncodingType.IDENTITY) {
                LOG.warn("No request compression algorithm available but compression config specified for service {}", (Object)httpServiceName);
            }
            return this._requestCompressionConfigs.get(httpServiceName);
        }
        return this._defaultRequestCompressionConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransportClient getClient(Map<String, ? extends Object> properties, SSLContext sslContext, SSLParameters sslParameters) {
        LOG.info("Getting a client with configuration {} and SSLContext {}", properties, (Object)sslContext);
        TransportClient client = this.getRawClient(properties, sslContext, sslParameters);
        List httpRequestServerSupportedEncodings = ConfigValueExtractor.buildList((Object)properties.remove(HTTP_REQUEST_CONTENT_ENCODINGS), (String)LIST_SEPARATOR);
        List httpResponseCompressionOperations = ConfigValueExtractor.buildList((Object)properties.remove(HTTP_RESPONSE_COMPRESSION_OPERATIONS), (String)LIST_SEPARATOR);
        String useResponseCompressionProperty = (String)properties.get(HTTP_USE_RESPONSE_COMPRESSION);
        if (useResponseCompressionProperty != null && Boolean.parseBoolean(useResponseCompressionProperty)) {
            httpResponseCompressionOperations.add("*");
        }
        FilterChain filters = this._filters;
        if (this._useClientCompression) {
            List responseEncodings = null;
            if (properties.containsKey(HTTP_RESPONSE_CONTENT_ENCODINGS)) {
                responseEncodings = ConfigValueExtractor.buildList((Object)properties.remove(HTTP_RESPONSE_CONTENT_ENCODINGS), (String)LIST_SEPARATOR);
            }
            String httpServiceName = (String)properties.get(HTTP_SERVICE_NAME);
            EncodingType restRequestContentEncoding = HttpClientFactory.getRestRequestContentEncoding(httpRequestServerSupportedEncodings);
            StreamEncodingType streamRequestContentEncoding = HttpClientFactory.getStreamRequestContentEncoding(httpRequestServerSupportedEncodings);
            if (restRequestContentEncoding != EncodingType.IDENTITY || !httpResponseCompressionOperations.isEmpty()) {
                filters = filters.addLastRest((RestFilter)new ClientCompressionFilter(restRequestContentEncoding, this.getRestRequestCompressionConfig(httpServiceName, restRequestContentEncoding), this.buildRestAcceptEncodingSchemaNames(responseEncodings), this._responseCompressionConfigs.get(httpServiceName), httpResponseCompressionOperations));
            }
            if (streamRequestContentEncoding != StreamEncodingType.IDENTITY || !httpResponseCompressionOperations.isEmpty()) {
                CompressionConfig compressionConfig = this.getStreamRequestCompressionConfig(httpServiceName, streamRequestContentEncoding);
                filters = filters.addLast((StreamFilter)new ClientStreamCompressionFilter(streamRequestContentEncoding, compressionConfig, this.buildStreamAcceptEncodingSchemas(responseEncodings), this._responseCompressionConfigs.get(httpServiceName), httpResponseCompressionOperations, this._compressionExecutor));
            }
        }
        Integer queryPostThreshold = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_QUERY_POST_THRESHOLD), Integer.MAX_VALUE);
        ClientQueryTunnelFilter clientQueryTunnelFilter = new ClientQueryTunnelFilter(queryPostThreshold.intValue());
        filters = filters.addLastRest((RestFilter)clientQueryTunnelFilter);
        filters = filters.addLast((StreamFilter)clientQueryTunnelFilter);
        Integer requestTimeout = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_REQUEST_TIMEOUT), 10000);
        DisruptFilter disruptFilter = new DisruptFilter(this._executor, (ExecutorService)this._eventLoopGroup, requestTimeout.intValue());
        filters = filters.addLastRest((RestFilter)disruptFilter);
        filters = filters.addLast((StreamFilter)disruptFilter);
        client = new FilterChainClient(client, filters);
        client = new FactoryClient(client);
        Object object = this._mutex;
        synchronized (object) {
            if (!this._running) {
                throw new IllegalStateException("Factory is shutting down");
            }
            ++this._clientsOutstanding;
            return client;
        }
    }

    private static StreamEncodingType getStreamRequestContentEncoding(List<String> serverSupportedEncodings) {
        for (String encoding : serverSupportedEncodings) {
            if (!StreamEncodingType.isSupported((String)encoding)) continue;
            return StreamEncodingType.get((String)encoding);
        }
        return StreamEncodingType.IDENTITY;
    }

    private static EncodingType getRestRequestContentEncoding(List<String> serverSupportedEncodings) {
        for (String encoding : serverSupportedEncodings) {
            if (!EncodingType.isSupported((String)encoding)) continue;
            return EncodingType.get((String)encoding);
        }
        return EncodingType.IDENTITY;
    }

    private StreamEncodingType[] buildStreamAcceptEncodingSchemas(List<String> encodings) {
        if (encodings != null) {
            ArrayList<StreamEncodingType> encodingTypes = new ArrayList<StreamEncodingType>();
            for (String encoding : encodings) {
                if (!StreamEncodingType.isSupported((String)encoding)) continue;
                encodingTypes.add(StreamEncodingType.get((String)encoding));
            }
            return encodingTypes.toArray(new StreamEncodingType[encodingTypes.size()]);
        }
        return DEFAULT_STREAM_RESPONSE_CONTENT_ENCODINGS;
    }

    private EncodingType[] buildRestAcceptEncodingSchemaNames(List<String> encodings) {
        if (encodings != null) {
            ArrayList<EncodingType> encodingTypes = new ArrayList<EncodingType>();
            for (String encoding : encodings) {
                if (!EncodingType.isSupported((String)encoding)) continue;
                encodingTypes.add(EncodingType.get((String)encoding));
            }
            return encodingTypes.toArray(new EncodingType[encodingTypes.size()]);
        }
        return DEFAULT_RESPONSE_CONTENT_ENCODINGS;
    }

    private HttpProtocolVersion getHttpProtocolVersion(Map<String, ? extends Object> properties, String propertyKey) {
        if (properties == null) {
            LOG.warn("passed a null raw client properties");
            return null;
        }
        if (properties.containsKey(propertyKey)) {
            return HttpProtocolVersion.valueOf((String)((String)properties.get(propertyKey)));
        }
        return null;
    }

    private Integer getIntValue(Map<String, ? extends Object> properties, String propertyKey) {
        if (properties == null) {
            LOG.warn("passed a null raw client properties");
            return null;
        }
        if (properties.containsKey(propertyKey)) {
            return Integer.parseInt((String)properties.get(propertyKey));
        }
        return null;
    }

    private Long getLongValue(Map<String, ? extends Object> properties, String propertyKey) {
        if (properties == null) {
            LOG.warn("passed a null raw client properties");
            return null;
        }
        if (properties.containsKey(propertyKey)) {
            return Long.parseLong((String)properties.get(propertyKey));
        }
        return null;
    }

    private AsyncPoolImpl.Strategy getStrategy(Map<String, ? extends Object> properties) {
        if (properties == null) {
            LOG.warn("passed a null raw client properties");
            return null;
        }
        if (properties.containsKey(HTTP_POOL_STRATEGY)) {
            String strategyString = (String)properties.get(HTTP_POOL_STRATEGY);
            if (strategyString.equalsIgnoreCase("LRU")) {
                return AsyncPoolImpl.Strategy.LRU;
            }
            if (strategyString.equalsIgnoreCase("MRU")) {
                return AsyncPoolImpl.Strategy.MRU;
            }
        }
        return null;
    }

    TransportClient getRawClient(Map<String, ? extends Object> properties, SSLContext sslContext, SSLParameters sslParameters) {
        AbstractNettyStreamClient streamClient;
        Integer poolSize = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_POOL_SIZE), 200);
        Integer idleTimeout = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_IDLE_TIMEOUT), 25000);
        Integer shutdownTimeout = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_SHUTDOWN_TIMEOUT), 5000);
        long maxResponseSize = this.chooseNewOverDefault(this.getLongValue(properties, HTTP_MAX_RESPONSE_SIZE), 0x200000L);
        Integer requestTimeout = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_REQUEST_TIMEOUT), 10000);
        Integer poolWaiterSize = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_POOL_WAITER_SIZE), Integer.MAX_VALUE);
        String clientName = null;
        if (properties != null && properties.containsKey(HTTP_SERVICE_NAME)) {
            clientName = properties.get(HTTP_SERVICE_NAME) + "Client";
        }
        clientName = this.chooseNewOverDefault(clientName, DEFAULT_CLIENT_NAME);
        AsyncPoolImpl.Strategy strategy = this.chooseNewOverDefault(this.getStrategy(properties), DEFAULT_POOL_STRATEGY);
        Integer poolMinSize = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_POOL_MIN_SIZE), 0);
        Integer maxHeaderSize = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_MAX_HEADER_SIZE), 8192);
        Integer maxChunkSize = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_MAX_CHUNK_SIZE), 8192);
        Integer maxConcurrentConnections = this.chooseNewOverDefault(this.getIntValue(properties, HTTP_MAX_CONCURRENT_CONNECTIONS), Integer.MAX_VALUE);
        HttpProtocolVersion httpProtocolVersion = this.chooseNewOverDefault(this.getHttpProtocolVersion(properties, HTTP_PROTOCOL_VERSION), this._defaultHttpVersion);
        switch (httpProtocolVersion) {
            case HTTP_1_1: {
                streamClient = new HttpNettyStreamClient(this._eventLoopGroup, this._executor, poolSize, requestTimeout.intValue(), idleTimeout.intValue(), shutdownTimeout.intValue(), maxResponseSize, sslContext, sslParameters, this._callbackExecutorGroup, poolWaiterSize, clientName + "-Stream", this._jmxManager, strategy, poolMinSize, maxHeaderSize, maxChunkSize, maxConcurrentConnections, this._tcpNoDelay);
                break;
            }
            case HTTP_2: {
                streamClient = new Http2NettyStreamClient(this._eventLoopGroup, this._executor, requestTimeout.intValue(), idleTimeout.intValue(), shutdownTimeout.intValue(), maxResponseSize, sslContext, sslParameters, this._callbackExecutorGroup, poolWaiterSize, clientName + "-HTTP/2-Stream", this._jmxManager, maxHeaderSize, maxChunkSize, maxConcurrentConnections, this._tcpNoDelay);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized HTTP protocol version " + httpProtocolVersion);
            }
        }
        HttpNettyClient legacyClient = new HttpNettyClient(this._eventLoopGroup, this._executor, poolSize, requestTimeout.intValue(), idleTimeout.intValue(), shutdownTimeout.intValue(), (int)maxResponseSize, sslContext, sslParameters, this._callbackExecutorGroup, poolWaiterSize, clientName, this._jmxManager, strategy, poolMinSize, maxHeaderSize, maxChunkSize, maxConcurrentConnections);
        return new MixedClient(legacyClient, streamClient);
    }

    private <T> T chooseNewOverDefault(T newValue, T defaultValue) {
        if (newValue == null) {
            return defaultValue;
        }
        return newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(Callback<None> callback) {
        int count;
        Object object = this._mutex;
        synchronized (object) {
            this._running = false;
            count = this._clientsOutstanding;
            this._factoryShutdownCallback = callback;
        }
        if (count == 0) {
            this.finishShutdown();
        } else {
            LOG.info("Awaiting shutdown of {} outstanding clients", (Object)count);
        }
    }

    public void shutdown(Callback<None> callback, long timeout, TimeUnit timeoutUnit) {
        this._shutdownTimeoutTask = this._executor.schedule(new Runnable(){

            @Override
            public void run() {
                LOG.warn("Shutdown timeout exceeded, proceeding with shutdown");
                HttpClientFactory.this.finishShutdown();
            }
        }, timeout, timeoutUnit);
        this.shutdown(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishShutdown() {
        Callback<None> callback;
        if (!this._finishingShutdown.compareAndSet(false, true)) {
            return;
        }
        if (this._shutdownTimeoutTask != null) {
            this._shutdownTimeoutTask.cancel(false);
        }
        if (this._shutdownFactory) {
            LOG.info("Shutdown Netty Event Loop");
            this._eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        }
        if (this._shutdownExecutor) {
            this._executor.shutdown();
            this._executor.shutdownNow();
            LOG.info("Scheduler shutdown complete");
        }
        if (this._shutdownCallbackExecutor) {
            LOG.info("Shutdown callback executor");
            this._callbackExecutorGroup.shutdown();
            this._callbackExecutorGroup.shutdownNow();
        }
        Object object = this._mutex;
        synchronized (object) {
            callback = this._factoryShutdownCallback;
        }
        LOG.info("Shutdown complete");
        callback.onSuccess((Object)None.none());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clientShutdown() {
        boolean done;
        Object object = this._mutex;
        synchronized (object) {
            --this._clientsOutstanding;
            done = !this._running && this._clientsOutstanding == 0;
        }
        if (done) {
            this.finishShutdown();
        }
    }

    static class MixedClient
    implements TransportClient {
        private final TransportClient _legacyClient;
        private final TransportClient _streamClient;

        MixedClient(TransportClient legacyClient, TransportClient streamClient) {
            this._legacyClient = legacyClient;
            this._streamClient = streamClient;
        }

        public void restRequest(RestRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<RestResponse> callback) {
            this._legacyClient.restRequest(request, requestContext, wireAttrs, callback);
        }

        public void streamRequest(StreamRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<StreamResponse> callback) {
            this._streamClient.streamRequest(request, requestContext, wireAttrs, callback);
        }

        public void shutdown(Callback<None> callback) {
            MultiCallback multiCallback = new MultiCallback(callback, 2);
            this._legacyClient.shutdown((Callback)multiCallback);
            this._streamClient.shutdown((Callback)multiCallback);
        }

        long getRequestTimeout() {
            return ((AbstractNettyStreamClient)this._streamClient).getRequestTimeout();
        }

        long getShutdownTimeout() {
            return ((AbstractNettyStreamClient)this._streamClient).getShutdownTimeout();
        }

        long getMaxResponseSize() {
            return ((AbstractNettyStreamClient)this._streamClient).getMaxResponseSize();
        }
    }

    private class FactoryClient
    implements TransportClient {
        private final TransportClient _client;
        private final AtomicBoolean _shutdown = new AtomicBoolean(false);

        private FactoryClient(TransportClient client) {
            this._client = client;
        }

        public void restRequest(RestRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<RestResponse> callback) {
            this._client.restRequest(request, requestContext, wireAttrs, callback);
        }

        public void streamRequest(StreamRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<StreamResponse> callback) {
            this._client.streamRequest(request, requestContext, wireAttrs, callback);
        }

        public void shutdown(final Callback<None> callback) {
            if (this._shutdown.compareAndSet(false, true)) {
                this._client.shutdown((Callback)new Callback<None>(){

                    public void onSuccess(None none) {
                        try {
                            callback.onSuccess((Object)none);
                        }
                        finally {
                            HttpClientFactory.this.clientShutdown();
                        }
                    }

                    public void onError(Throwable e) {
                        try {
                            callback.onError(e);
                        }
                        finally {
                            HttpClientFactory.this.clientShutdown();
                        }
                    }
                });
            } else {
                callback.onError((Throwable)new IllegalStateException("shutdown has already been requested."));
            }
        }
    }

    public static class Builder {
        private NioEventLoopGroup _eventLoopGroup = null;
        private ScheduledExecutorService _executor = null;
        private ExecutorService _callbackExecutorGroup = null;
        private boolean _shutdownFactory = true;
        private boolean _shutdownExecutor = true;
        private boolean _shutdownCallbackExecutor = false;
        private FilterChain _filters = FilterChains.empty();
        private Executor _compressionExecutor = null;
        private AbstractJmxManager _jmxManager = AbstractJmxManager.NULL_JMX_MANAGER;
        private int _requestCompressionThresholdDefault = Integer.MAX_VALUE;
        private Map<String, CompressionConfig> _requestCompressionConfigs = Collections.emptyMap();
        private Map<String, CompressionConfig> _responseCompressionConfigs = Collections.emptyMap();
        private boolean _tcpNoDelay = true;
        private HttpProtocolVersion _defaultHttpVersion = HttpProtocolVersion.HTTP_1_1;

        public Builder setNioEventLoopGroup(NioEventLoopGroup nioEventLoopGroup) {
            this._eventLoopGroup = nioEventLoopGroup;
            return this;
        }

        public Builder setScheduleExecutorService(ScheduledExecutorService scheduleExecutorService) {
            this._executor = scheduleExecutorService;
            return this;
        }

        public Builder setCallbackExecutor(ExecutorService callbackExecutor) {
            this._callbackExecutorGroup = callbackExecutor;
            return this;
        }

        public Builder setShutDownFactory(boolean shutDownFactory) {
            this._shutdownFactory = shutDownFactory;
            return this;
        }

        public Builder setShutdownScheduledExecutorService(boolean shutdown) {
            this._shutdownExecutor = shutdown;
            return this;
        }

        public Builder setShutdownCallbackExecutor(boolean shutdown) {
            this._shutdownCallbackExecutor = shutdown;
            return this;
        }

        public Builder setFilterChain(FilterChain filterChain) {
            this._filters = filterChain;
            return this;
        }

        public Builder setCompressionExecutor(Executor executor) {
            this._compressionExecutor = executor;
            return this;
        }

        public Builder setJmxManager(AbstractJmxManager jmxManager) {
            this._jmxManager = jmxManager;
            return this;
        }

        public Builder setRequestCompressionThresholdDefault(int thresholdDefault) {
            this._requestCompressionThresholdDefault = thresholdDefault;
            return this;
        }

        public Builder setRequestCompressionConfigs(Map<String, CompressionConfig> configs) {
            this._requestCompressionConfigs = configs;
            return this;
        }

        public Builder setResponseCompressionConfigs(Map<String, CompressionConfig> configs) {
            this._responseCompressionConfigs = configs;
            return this;
        }

        public Builder setTcpNoDelay(boolean tcpNoDelay) {
            this._tcpNoDelay = tcpNoDelay;
            return this;
        }

        public Builder setDefaultHttpVersion(HttpProtocolVersion defaultHttpVersion) {
            this._defaultHttpVersion = defaultHttpVersion;
            return this;
        }

        public HttpClientFactory build() {
            NioEventLoopGroup eventLoopGroup = this._eventLoopGroup != null ? this._eventLoopGroup : new NioEventLoopGroup(0, (ThreadFactory)new NamedThreadFactory("R2 Nio Event Loop"));
            ScheduledExecutorService scheduledExecutorService = this._executor != null ? this._executor : Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("R2 Netty Scheduler"));
            return new HttpClientFactory(this._filters, eventLoopGroup, this._shutdownFactory, scheduledExecutorService, this._shutdownExecutor, this._callbackExecutorGroup, this._shutdownCallbackExecutor, this._jmxManager, this._requestCompressionThresholdDefault, this._requestCompressionConfigs, this._responseCompressionConfigs, this._tcpNoDelay, this._compressionExecutor, this._defaultHttpVersion);
        }
    }
}

