/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.r2.message.Request;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class SslRequestHandler
extends ChannelOutboundHandlerAdapter {
    private static final String HTTPS_SCHEME = "https";
    private static final String SSL_HANDLER = "SslHandler";
    private final SslHandler _sslHandler;
    private String _firstTimeScheme;

    public SslRequestHandler(SSLContext sslContext, SSLParameters sslParameters) {
        if (sslContext == null) {
            this._sslHandler = null;
        } else {
            SSLEngine sslEngine = sslContext.createSSLEngine();
            sslEngine.setUseClientMode(true);
            if (sslParameters != null) {
                String[] protocols;
                String[] cipherSuites = sslParameters.getCipherSuites();
                if (cipherSuites != null && cipherSuites.length > 0) {
                    sslEngine.setEnabledCipherSuites(sslParameters.getCipherSuites());
                }
                if ((protocols = sslParameters.getProtocols()) != null && protocols.length > 0) {
                    sslEngine.setEnabledProtocols(sslParameters.getProtocols());
                }
            }
            this._sslHandler = new SslHandler(sslEngine);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Request) {
            Request request = (Request)msg;
            URI uri = request.getURI();
            String scheme = uri.getScheme();
            if (this._firstTimeScheme == null) {
                if (scheme.equalsIgnoreCase(HTTPS_SCHEME)) {
                    if (this._sslHandler == null) {
                        throw new IllegalStateException("The client hasn't been configured with SSLContext - cannot make an https request to " + uri);
                    }
                    ctx.pipeline().addFirst(SSL_HANDLER, (ChannelHandler)this._sslHandler);
                }
                this._firstTimeScheme = scheme;
            } else if (!scheme.equalsIgnoreCase(this._firstTimeScheme)) {
                throw new IllegalStateException(String.format("Cannot switch scheme from %s to %s for %s", this._firstTimeScheme, scheme, ctx.channel().remoteAddress()));
            }
        }
        ctx.write(msg, promise);
    }

    public void flush(final ChannelHandlerContext ctx) throws Exception {
        if (this._firstTimeScheme == null) {
            throw new IllegalStateException("Flush is called before any request has been written into this channel!");
        }
        if (this._firstTimeScheme.equalsIgnoreCase(HTTPS_SCHEME)) {
            this._sslHandler.handshakeFuture().addListener((GenericFutureListener)new FutureListener<Channel>(){

                public void operationComplete(Future<Channel> future) throws Exception {
                    ctx.flush();
                }
            });
        } else {
            ctx.flush();
        }
    }
}

