/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.server;

import com.linkedin.r2.filter.FilterChain;
import com.linkedin.r2.filter.FilterChains;
import com.linkedin.r2.filter.transport.FilterChainDispatcher;
import com.linkedin.r2.transport.common.bridge.server.TransportDispatcher;
import com.linkedin.r2.transport.http.server.HttpDispatcher;
import com.linkedin.r2.transport.http.server.HttpNettyServer;
import com.linkedin.r2.transport.http.server.HttpServer;

public class HttpNettyServerFactory {
    public static final int DEFAULT_THREAD_POOL_SIZE = 256;
    private final FilterChain _filters;

    public HttpNettyServerFactory() {
        this(FilterChains.empty());
    }

    public HttpNettyServerFactory(FilterChain filters) {
        this._filters = filters;
    }

    public HttpServer createServer(int port, TransportDispatcher transportDispatcher) {
        return this.createServer(port, 256, transportDispatcher);
    }

    public HttpServer createServer(int port, int threadPoolSize, TransportDispatcher transportDispatcher) {
        FilterChainDispatcher filterDispatcher = new FilterChainDispatcher(transportDispatcher, this._filters);
        HttpDispatcher dispatcher = new HttpDispatcher((TransportDispatcher)filterDispatcher);
        return new HttpNettyServer(port, threadPoolSize, dispatcher);
    }
}

